@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.asset.AssetOrArchive
import com.pulumi.aws.s3.BucketObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an S3 object resource.
 * ## Example Usage
 * ### Encrypting with KMS Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplekms = new Key("examplekms", KeyArgs.builder()
 *             .description("KMS key 1")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .kmsKeyId(examplekms.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Server Side Encryption with S3 Default Master Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .serverSideEncryption("aws:kms")
 *             .build());
 *     }
 * }
 * ```
 * ### Server Side Encryption with AWS-Managed Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("index.html"))
 *             .serverSideEncryption("AES256")
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Object Lock
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketObject;
 * import com.pulumi.aws.s3.BucketObjectArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplebucket = new BucketV2("examplebucket", BucketV2Args.builder()
 *             .objectLockEnabled(true)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .acl("private")
 *             .build());
 *         var exampleBucketVersioningV2 = new BucketVersioningV2("exampleBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(examplebucket.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var exampleBucketObject = new BucketObject("exampleBucketObject", BucketObjectArgs.builder()
 *             .key("someobject")
 *             .bucket(examplebucket.id())
 *             .source(new FileAsset("important.txt"))
 *             .objectLockLegalHoldStatus("ON")
 *             .objectLockMode("GOVERNANCE")
 *             .objectLockRetainUntilDate("2021-12-31T23:59:60Z")
 *             .forceDestroy(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using S3 URL syntax:
 * __Using `pulumi import` to import__ objects using the `id` or S3 URL. For example:
 * Import using the `id`, which is the bucket name and the key together:
 * ```sh
 *  $ pulumi import aws:s3/bucketObject:BucketObject example some-bucket-name/some/key.txt
 * ```
 *  Import using S3 URL syntax:
 * ```sh
 *  $ pulumi import aws:s3/bucketObject:BucketObject example s3://some-bucket-name/some/key.txt
 * ```
 * @property acl [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Defaults to `private`.
 * @property bucket Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 * @property cacheControl Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
 * @property content Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
 * @property contentBase64 Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
 * @property contentDisposition Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
 * @property contentEncoding Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
 * @property contentLanguage Language the content is in e.g., en-US or en-GB.
 * @property contentType Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
 * @property etag Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"` (see `source_hash` instead).
 * @property forceDestroy Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
 * @property key Name of the object once it is in the bucket.
 * The following arguments are optional:
 * @property kmsKeyId ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `aws.kms.Key` resource, use the `arn` attribute. If referencing the `aws.kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
 * @property metadata Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
 * @property objectLockLegalHoldStatus [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
 * @property objectLockMode Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
 * @property objectLockRetainUntilDate Date and time, in [RFC3339 format](https://tools&#46;ietf&#46;org/html/rfc3339#section-5&#46;8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
 * @property serverSideEncryption Server-side encryption of the object in S3. Valid values are "`AES256`" and "`aws:kms`".
 * @property source Path to a file that will be read and uploaded as raw bytes for the object content.
 * @property sourceHash Triggers updates like `etag` but useful to address `etag` encryption limitations.
 * @property storageClass [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
 * @property tags Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property websiteRedirect Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
 * If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
 */
public data class BucketObjectArgs(
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val bucketKeyEnabled: Output<Boolean>? = null,
    public val cacheControl: Output<String>? = null,
    public val content: Output<String>? = null,
    public val contentBase64: Output<String>? = null,
    public val contentDisposition: Output<String>? = null,
    public val contentEncoding: Output<String>? = null,
    public val contentLanguage: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val etag: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val objectLockLegalHoldStatus: Output<String>? = null,
    public val objectLockMode: Output<String>? = null,
    public val objectLockRetainUntilDate: Output<String>? = null,
    public val serverSideEncryption: Output<String>? = null,
    public val source: Output<AssetOrArchive>? = null,
    public val sourceHash: Output<String>? = null,
    public val storageClass: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val websiteRedirect: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketObjectArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketObjectArgs =
        com.pulumi.aws.s3.BucketObjectArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .bucketKeyEnabled(bucketKeyEnabled?.applyValue({ args0 -> args0 }))
            .cacheControl(cacheControl?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentBase64(contentBase64?.applyValue({ args0 -> args0 }))
            .contentDisposition(contentDisposition?.applyValue({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.applyValue({ args0 -> args0 }))
            .contentLanguage(contentLanguage?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .objectLockLegalHoldStatus(objectLockLegalHoldStatus?.applyValue({ args0 -> args0 }))
            .objectLockMode(objectLockMode?.applyValue({ args0 -> args0 }))
            .objectLockRetainUntilDate(objectLockRetainUntilDate?.applyValue({ args0 -> args0 }))
            .serverSideEncryption(serverSideEncryption?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceHash(sourceHash?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .websiteRedirect(websiteRedirect?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketObjectArgs].
 */
@PulumiTagMarker
public class BucketObjectArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    private var bucketKeyEnabled: Output<Boolean>? = null

    private var cacheControl: Output<String>? = null

    private var content: Output<String>? = null

    private var contentBase64: Output<String>? = null

    private var contentDisposition: Output<String>? = null

    private var contentEncoding: Output<String>? = null

    private var contentLanguage: Output<String>? = null

    private var contentType: Output<String>? = null

    private var etag: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var objectLockLegalHoldStatus: Output<String>? = null

    private var objectLockMode: Output<String>? = null

    private var objectLockRetainUntilDate: Output<String>? = null

    private var serverSideEncryption: Output<String>? = null

    private var source: Output<AssetOrArchive>? = null

    private var sourceHash: Output<String>? = null

    private var storageClass: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var websiteRedirect: Output<String>? = null

    /**
     * @param value [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Defaults to `private`.
     */
    @JvmName("smnuscffegodkdep")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
     */
    @JvmName("qmclippgktepenpf")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("edrecaoviveilygv")
    public suspend fun bucketKeyEnabled(`value`: Output<Boolean>) {
        this.bucketKeyEnabled = value
    }

    /**
     * @param value Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
     */
    @JvmName("ewkkiuhlsrrlryjq")
    public suspend fun cacheControl(`value`: Output<String>) {
        this.cacheControl = value
    }

    /**
     * @param value Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
     */
    @JvmName("oplyoxlyvxwgpctg")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
     */
    @JvmName("nyggeypddagrqkpf")
    public suspend fun contentBase64(`value`: Output<String>) {
        this.contentBase64 = value
    }

    /**
     * @param value Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
     */
    @JvmName("ejjcvkrlshqpynwp")
    public suspend fun contentDisposition(`value`: Output<String>) {
        this.contentDisposition = value
    }

    /**
     * @param value Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
     */
    @JvmName("ocnbeydqkqvbarih")
    public suspend fun contentEncoding(`value`: Output<String>) {
        this.contentEncoding = value
    }

    /**
     * @param value Language the content is in e.g., en-US or en-GB.
     */
    @JvmName("ikionmfporamrdpo")
    public suspend fun contentLanguage(`value`: Output<String>) {
        this.contentLanguage = value
    }

    /**
     * @param value Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
     */
    @JvmName("lcpeetadjklkhwjs")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"` (see `source_hash` instead).
     */
    @JvmName("jlbxptlwlxlvjjfx")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
     */
    @JvmName("ebbxqckjcyywvfnj")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the object once it is in the bucket.
     * The following arguments are optional:
     */
    @JvmName("wytvbdsvmnpnvkwv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `aws.kms.Key` resource, use the `arn` attribute. If referencing the `aws.kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("muybknrolalsrgyy")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
     */
    @JvmName("rtbanahdvrhrocrn")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
     */
    @JvmName("ahrjgejfdoqxvhcg")
    public suspend fun objectLockLegalHoldStatus(`value`: Output<String>) {
        this.objectLockLegalHoldStatus = value
    }

    /**
     * @param value Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    @JvmName("ixpntnhflarxuqxl")
    public suspend fun objectLockMode(`value`: Output<String>) {
        this.objectLockMode = value
    }

    /**
     * @param value Date and time, in [RFC3339 format](https://tools&#46;ietf&#46;org/html/rfc3339#section-5&#46;8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
     */
    @JvmName("uhyqmfikpggjtmlu")
    public suspend fun objectLockRetainUntilDate(`value`: Output<String>) {
        this.objectLockRetainUntilDate = value
    }

    /**
     * @param value Server-side encryption of the object in S3. Valid values are "`AES256`" and "`aws:kms`".
     */
    @JvmName("sjmjxwkhmhaffrhd")
    public suspend fun serverSideEncryption(`value`: Output<String>) {
        this.serverSideEncryption = value
    }

    /**
     * @param value Path to a file that will be read and uploaded as raw bytes for the object content.
     */
    @JvmName("qkbpblisbabnokgn")
    public suspend fun source(`value`: Output<AssetOrArchive>) {
        this.source = value
    }

    /**
     * @param value Triggers updates like `etag` but useful to address `etag` encryption limitations.
     */
    @JvmName("kuawidcnuagtywvo")
    public suspend fun sourceHash(`value`: Output<String>) {
        this.sourceHash = value
    }

    /**
     * @param value [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
     */
    @JvmName("iyjeqncmxtofreio")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqdxidftcfyujium")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
     * If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
     */
    @JvmName("mlpyiuyuydaldkek")
    public suspend fun websiteRedirect(`value`: Output<String>) {
        this.websiteRedirect = value
    }

    /**
     * @param value [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Defaults to `private`.
     */
    @JvmName("damishhgeeycciwl")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
     */
    @JvmName("nekiyqobxwhjawxe")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("cadocyfuluoctkay")
    public suspend fun bucketKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketKeyEnabled = mapped
    }

    /**
     * @param value Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
     */
    @JvmName("freyooxvhogmsemf")
    public suspend fun cacheControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheControl = mapped
    }

    /**
     * @param value Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
     */
    @JvmName("lhignuovrjhrsmsf")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
     */
    @JvmName("uipnotjmoukygira")
    public suspend fun contentBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentBase64 = mapped
    }

    /**
     * @param value Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
     */
    @JvmName("dskbkvlwjqdkplru")
    public suspend fun contentDisposition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentDisposition = mapped
    }

    /**
     * @param value Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
     */
    @JvmName("ubjypconjwjjxago")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentEncoding = mapped
    }

    /**
     * @param value Language the content is in e.g., en-US or en-GB.
     */
    @JvmName("qygsntnjssjkkwmh")
    public suspend fun contentLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLanguage = mapped
    }

    /**
     * @param value Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
     */
    @JvmName("pqhgdmlnufrbstbf")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"` (see `source_hash` instead).
     */
    @JvmName("qkvmwlbaomqxuacv")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
     */
    @JvmName("jwvypslwtibvsvjl")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the object once it is in the bucket.
     * The following arguments are optional:
     */
    @JvmName("dtudtgieextrxvnb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `aws.kms.Key` resource, use the `arn` attribute. If referencing the `aws.kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("ywyisgrefyqxkaar")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
     */
    @JvmName("rtlvsdkfkbahuewi")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
     */
    @JvmName("jmqsxwijjaikpgyu")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
     */
    @JvmName("ulnhbvteegvhvfso")
    public suspend fun objectLockLegalHoldStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockLegalHoldStatus = mapped
    }

    /**
     * @param value Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     */
    @JvmName("wikennminxhqtlby")
    public suspend fun objectLockMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockMode = mapped
    }

    /**
     * @param value Date and time, in [RFC3339 format](https://tools&#46;ietf&#46;org/html/rfc3339#section-5&#46;8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
     */
    @JvmName("cqmsttnwtuolahxw")
    public suspend fun objectLockRetainUntilDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockRetainUntilDate = mapped
    }

    /**
     * @param value Server-side encryption of the object in S3. Valid values are "`AES256`" and "`aws:kms`".
     */
    @JvmName("culkkhrdwrtqtatc")
    public suspend fun serverSideEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryption = mapped
    }

    /**
     * @param value Path to a file that will be read and uploaded as raw bytes for the object content.
     */
    @JvmName("htytxpxyoldgfdfk")
    public suspend fun source(`value`: AssetOrArchive?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Triggers updates like `etag` but useful to address `etag` encryption limitations.
     */
    @JvmName("nfrebuvycbecklno")
    public suspend fun sourceHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceHash = mapped
    }

    /**
     * @param value [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
     */
    @JvmName("xmfrhxpboxkwsxuj")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jhrchbaujnmedyic")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lowirtcrcollxocx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
     * If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
     */
    @JvmName("voatusuxcpkdjojb")
    public suspend fun websiteRedirect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteRedirect = mapped
    }

    internal fun build(): BucketObjectArgs = BucketObjectArgs(
        acl = acl,
        bucket = bucket,
        bucketKeyEnabled = bucketKeyEnabled,
        cacheControl = cacheControl,
        content = content,
        contentBase64 = contentBase64,
        contentDisposition = contentDisposition,
        contentEncoding = contentEncoding,
        contentLanguage = contentLanguage,
        contentType = contentType,
        etag = etag,
        forceDestroy = forceDestroy,
        key = key,
        kmsKeyId = kmsKeyId,
        metadata = metadata,
        objectLockLegalHoldStatus = objectLockLegalHoldStatus,
        objectLockMode = objectLockMode,
        objectLockRetainUntilDate = objectLockRetainUntilDate,
        serverSideEncryption = serverSideEncryption,
        source = source,
        sourceHash = sourceHash,
        storageClass = storageClass,
        tags = tags,
        websiteRedirect = websiteRedirect,
    )
}
