@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketObjectLockConfigurationV2Rule
import com.pulumi.aws.s3.kotlin.outputs.BucketObjectLockConfigurationV2Rule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketObjectLockConfigurationV2].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketObjectLockConfigurationV2Args = BucketObjectLockConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketObjectLockConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketObjectLockConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketObjectLockConfigurationV2 {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketObjectLockConfigurationV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketObjectLockConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket Object Lock configuration resource. For more information about Object Locking, go to [Using S3 Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html) in the Amazon S3 User Guide.
 * > **NOTE:** This resource **does not enable** Object Lock for **new** buckets. It configures a default retention period for objects placed in the specified bucket.
 * Thus, to **enable** Object Lock for a **new** bucket, see the Using object lock configuration section in  the `aws.s3.BucketV2` resource or the Object Lock configuration for a new bucket example below.
 * If you want to **enable** Object Lock for an **existing** bucket, contact AWS Support and see the Object Lock configuration for an existing bucket example below.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Object Lock configuration for a new bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleDefaultRetentionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .objectLockEnabled(true)
 *             .build());
 *         var exampleBucketObjectLockConfigurationV2 = new BucketObjectLockConfigurationV2("exampleBucketObjectLockConfigurationV2", BucketObjectLockConfigurationV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketObjectLockConfigurationV2RuleArgs.builder()
 *                 .defaultRetention(BucketObjectLockConfigurationV2RuleDefaultRetentionArgs.builder()
 *                     .mode("COMPLIANCE")
 *                     .days(5)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Object Lock configuration for an existing bucket
 * This is a multistep process that requires AWS Support intervention.
 * 1. Enable versioning on your S3 bucket, if you have not already done so.
 * Doing so will generate an "Object Lock token" in the back-end.
 * <!-- markdownlint-disable MD029 -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketVersioningV2 = new BucketVersioningV2("exampleBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * import {
 *  to = aws_s3_bucket_object_lock_configuration.example
 *  id = "bucket-name,123456789012" }
 * __Using `pulumi import` to import__ S3 bucket Object Lock configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name,123456789012
 * ```
 *
 */
public class BucketObjectLockConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketObjectLockConfigurationV2,
) : KotlinCustomResource(javaResource, BucketObjectLockConfigurationV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
     */
    public val objectLockEnabled: Output<String>?
        get() = javaResource.objectLockEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for specifying the Object Lock rule for the specified object. See below.
     */
    public val rule: Output<BucketObjectLockConfigurationV2Rule>?
        get() = javaResource.rule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket's "Object Lock token".
     * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BucketObjectLockConfigurationV2Mapper :
    ResourceMapper<BucketObjectLockConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketObjectLockConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketObjectLockConfigurationV2 =
        BucketObjectLockConfigurationV2(
            javaResource as
                com.pulumi.aws.s3.BucketObjectLockConfigurationV2,
        )
}

/**
 * @see [BucketObjectLockConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketObjectLockConfigurationV2].
 */
public suspend fun bucketObjectLockConfigurationV2(
    name: String,
    block: suspend BucketObjectLockConfigurationV2ResourceBuilder.() -> Unit,
):
    BucketObjectLockConfigurationV2 {
    val builder = BucketObjectLockConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketObjectLockConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketObjectLockConfigurationV2(name: String): BucketObjectLockConfigurationV2 {
    val builder = BucketObjectLockConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
