@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketObjectLockConfigurationV2RuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketObjectLockConfigurationV2RuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket Object Lock configuration resource. For more information about Object Locking, go to [Using S3 Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html) in the Amazon S3 User Guide.
 * > **NOTE:** This resource **does not enable** Object Lock for **new** buckets. It configures a default retention period for objects placed in the specified bucket.
 * Thus, to **enable** Object Lock for a **new** bucket, see the Using object lock configuration section in  the `aws.s3.BucketV2` resource or the Object Lock configuration for a new bucket example below.
 * If you want to **enable** Object Lock for an **existing** bucket, contact AWS Support and see the Object Lock configuration for an existing bucket example below.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Object Lock configuration for a new bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleDefaultRetentionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .objectLockEnabled(true)
 *             .build());
 *         var exampleBucketObjectLockConfigurationV2 = new BucketObjectLockConfigurationV2("exampleBucketObjectLockConfigurationV2", BucketObjectLockConfigurationV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketObjectLockConfigurationV2RuleArgs.builder()
 *                 .defaultRetention(BucketObjectLockConfigurationV2RuleDefaultRetentionArgs.builder()
 *                     .mode("COMPLIANCE")
 *                     .days(5)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Object Lock configuration for an existing bucket
 * This is a multistep process that requires AWS Support intervention.
 * 1. Enable versioning on your S3 bucket, if you have not already done so.
 * Doing so will generate an "Object Lock token" in the back-end.
 * <!-- markdownlint-disable MD029 -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketVersioningV2 = new BucketVersioningV2("exampleBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * import {
 *  to = aws_s3_bucket_object_lock_configuration.example
 *  id = "bucket-name,123456789012" }
 * __Using `pulumi import` to import__ S3 bucket Object Lock configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
 * @property rule Configuration block for specifying the Object Lock rule for the specified object. See below.
 * @property token Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket's "Object Lock token".
 * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
 */
public data class BucketObjectLockConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val objectLockEnabled: Output<String>? = null,
    public val rule: Output<BucketObjectLockConfigurationV2RuleArgs>? = null,
    public val token: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args =
        com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .objectLockEnabled(objectLockEnabled?.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketObjectLockConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var objectLockEnabled: Output<String>? = null

    private var rule: Output<BucketObjectLockConfigurationV2RuleArgs>? = null

    private var token: Output<String>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("qjmskeqkmtdloykh")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("dsnbdtayjrwsrhnu")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
     */
    @JvmName("nucolulrrpogajur")
    public suspend fun objectLockEnabled(`value`: Output<String>) {
        this.objectLockEnabled = value
    }

    /**
     * @param value Configuration block for specifying the Object Lock rule for the specified object. See below.
     */
    @JvmName("slbkysbvkooretkd")
    public suspend fun rule(`value`: Output<BucketObjectLockConfigurationV2RuleArgs>) {
        this.rule = value
    }

    /**
     * @param value Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket's "Object Lock token".
     * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
     */
    @JvmName("skbkspffgwmbygpl")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("htqierltjxnmmhvv")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("tkinscmtyuuebrmi")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
     */
    @JvmName("gacpmrhcrvorcrei")
    public suspend fun objectLockEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockEnabled = mapped
    }

    /**
     * @param value Configuration block for specifying the Object Lock rule for the specified object. See below.
     */
    @JvmName("xjwpkadrfgtckots")
    public suspend fun rule(`value`: BucketObjectLockConfigurationV2RuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument Configuration block for specifying the Object Lock rule for the specified object. See below.
     */
    @JvmName("bbikrajahtvubymn")
    public suspend
    fun rule(argument: suspend BucketObjectLockConfigurationV2RuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationV2RuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    /**
     * @param value Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket's "Object Lock token".
     * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
     */
    @JvmName("mlydornyadukfbox")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): BucketObjectLockConfigurationV2Args = BucketObjectLockConfigurationV2Args(
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
        objectLockEnabled = objectLockEnabled,
        rule = rule,
        token = token,
    )
}
