@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketOwnershipControlsArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketOwnershipControlsRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketOwnershipControlsRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage S3 Bucket Ownership Controls. For more information, see the [S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketOwnershipControls;
 * import com.pulumi.aws.s3.BucketOwnershipControlsArgs;
 * import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketOwnershipControls = new BucketOwnershipControls("exampleBucketOwnershipControls", BucketOwnershipControlsArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketOwnershipControlsRuleArgs.builder()
 *                 .objectOwnership("BucketOwnerPreferred")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Bucket Ownership Controls using S3 Bucket name. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketOwnershipControls:BucketOwnershipControls example my-bucket
 * ```
 * @property bucket Name of the bucket that you want to associate this access point with.
 * @property rule Configuration block(s) with Ownership Controls rules. Detailed below.
 */
public data class BucketOwnershipControlsArgs(
    public val bucket: Output<String>? = null,
    public val rule: Output<BucketOwnershipControlsRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketOwnershipControlsArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketOwnershipControlsArgs =
        com.pulumi.aws.s3.BucketOwnershipControlsArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketOwnershipControlsArgs].
 */
@PulumiTagMarker
public class BucketOwnershipControlsArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var rule: Output<BucketOwnershipControlsRuleArgs>? = null

    /**
     * @param value Name of the bucket that you want to associate this access point with.
     */
    @JvmName("uthxfkinswpgwvew")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("cspcvgnvyuqgskls")
    public suspend fun rule(`value`: Output<BucketOwnershipControlsRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value Name of the bucket that you want to associate this access point with.
     */
    @JvmName("unxjkpktrokkqoim")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("epwqssxrjpmvytao")
    public suspend fun rule(`value`: BucketOwnershipControlsRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument Configuration block(s) with Ownership Controls rules. Detailed below.
     */
    @JvmName("bfsydxbtaarmmkty")
    public suspend fun rule(argument: suspend BucketOwnershipControlsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketOwnershipControlsRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    internal fun build(): BucketOwnershipControlsArgs = BucketOwnershipControlsArgs(
        bucket = bucket,
        rule = rule,
    )
}
