@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketPolicy].
 */
@PulumiTagMarker
public class BucketPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketPolicyArgs = BucketPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketPolicyArgsBuilder.() -> Unit) {
        val builder = BucketPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketPolicy {
        val builtJavaResource = com.pulumi.aws.s3.BucketPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketPolicy(builtJavaResource)
    }
}

/**
 * Attaches a policy to an S3 bucket resource.
 * > Policies can be attached to both S3 general purpose buckets and S3 directory buckets.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example");
 *         final var allowAccessFromAnotherAccountPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions(
 *                     "s3:GetObject",
 *                     "s3:ListBucket")
 *                 .resources(
 *                     example.arn(),
 *                     example.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var allowAccessFromAnotherAccountBucketPolicy = new BucketPolicy("allowAccessFromAnotherAccountBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(example.id())
 *             .policy(allowAccessFromAnotherAccountPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowAccessFromAnotherAccountPolicyDocument -> allowAccessFromAnotherAccountPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket policies using the bucket name. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketPolicy:BucketPolicy allow_access_from_another_account my-tf-test-bucket
 * ```
 * */
 */
public class BucketPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketPolicy,
) : KotlinCustomResource(javaResource, BucketPolicyMapper) {
    /**
     * Name of the bucket to which to apply the policy.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Text of the policy. Although this is a bucket policy rather than an IAM policy, the `aws.iam.getPolicyDocument` data source may be used, so long as it specifies a principal. For more information about building AWS IAM policy documents, see the AWS IAM Policy Document Guide. Note: Bucket policies are limited to 20 KB in size.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object BucketPolicyMapper : ResourceMapper<BucketPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BucketPolicy = BucketPolicy(
        javaResource as
            com.pulumi.aws.s3.BucketPolicy,
    )
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketPolicy].
 */
public suspend fun bucketPolicy(
    name: String,
    block: suspend BucketPolicyResourceBuilder.() -> Unit,
): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketPolicy(name: String): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
