@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketPublicAccessBlock].
 */
@PulumiTagMarker
public class BucketPublicAccessBlockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketPublicAccessBlockArgs = BucketPublicAccessBlockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketPublicAccessBlockArgsBuilder.() -> Unit) {
        val builder = BucketPublicAccessBlockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketPublicAccessBlock {
        val builtJavaResource = com.pulumi.aws.s3.BucketPublicAccessBlock(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketPublicAccessBlock(builtJavaResource)
    }
}

/**
 * Manages S3 bucket-level Public Access Block configuration. For more information about these settings, see the [AWS S3 Block Public Access documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketPublicAccessBlock;
 * import com.pulumi.aws.s3.BucketPublicAccessBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketPublicAccessBlock = new BucketPublicAccessBlock("exampleBucketPublicAccessBlock", BucketPublicAccessBlockArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .blockPublicAcls(true)
 *             .blockPublicPolicy(true)
 *             .ignorePublicAcls(true)
 *             .restrictPublicBuckets(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_s3_bucket_public_access_block` using the bucket name. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketPublicAccessBlock:BucketPublicAccessBlock example my-bucket
 * ```
 *
 */
public class BucketPublicAccessBlock internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketPublicAccessBlock,
) : KotlinCustomResource(javaResource, BucketPublicAccessBlockMapper) {
    /**
     * Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls will fail if the request includes an object ACL.
     */
    public val blockPublicAcls: Output<Boolean>?
        get() = javaResource.blockPublicAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    public val blockPublicPolicy: Output<Boolean>?
        get() = javaResource.blockPublicPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 Bucket to which this Public Access Block configuration should be applied.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore public ACLs on this bucket and any objects that it contains.
     */
    public val ignorePublicAcls: Output<Boolean>?
        get() = javaResource.ignorePublicAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
     */
    public val restrictPublicBuckets: Output<Boolean>?
        get() = javaResource.restrictPublicBuckets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketPublicAccessBlockMapper : ResourceMapper<BucketPublicAccessBlock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketPublicAccessBlock::class == javaResource::class

    override fun map(javaResource: Resource): BucketPublicAccessBlock =
        BucketPublicAccessBlock(javaResource as com.pulumi.aws.s3.BucketPublicAccessBlock)
}

/**
 * @see [BucketPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketPublicAccessBlock].
 */
public suspend fun bucketPublicAccessBlock(
    name: String,
    block: suspend BucketPublicAccessBlockResourceBuilder.() -> Unit,
): BucketPublicAccessBlock {
    val builder = BucketPublicAccessBlockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketPublicAccessBlock(name: String): BucketPublicAccessBlock {
    val builder = BucketPublicAccessBlockResourceBuilder()
    builder.name(name)
    return builder.build()
}
