@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketPublicAccessBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages S3 bucket-level Public Access Block configuration. For more information about these settings, see the [AWS S3 Block Public Access documentation](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketPublicAccessBlock;
 * import com.pulumi.aws.s3.BucketPublicAccessBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketPublicAccessBlock = new BucketPublicAccessBlock("exampleBucketPublicAccessBlock", BucketPublicAccessBlockArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .blockPublicAcls(true)
 *             .blockPublicPolicy(true)
 *             .ignorePublicAcls(true)
 *             .restrictPublicBuckets(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_s3_bucket_public_access_block` using the bucket name. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketPublicAccessBlock:BucketPublicAccessBlock example my-bucket
 * ```
 * @property blockPublicAcls Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
 * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
 * * PUT Object calls will fail if the request includes an object ACL.
 * @property blockPublicPolicy Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
 * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
 * @property bucket S3 Bucket to which this Public Access Block configuration should be applied.
 * @property ignorePublicAcls Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
 * * Ignore public ACLs on this bucket and any objects that it contains.
 * @property restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
 * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
 */
public data class BucketPublicAccessBlockArgs(
    public val blockPublicAcls: Output<Boolean>? = null,
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val bucket: Output<String>? = null,
    public val ignorePublicAcls: Output<Boolean>? = null,
    public val restrictPublicBuckets: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketPublicAccessBlockArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketPublicAccessBlockArgs =
        com.pulumi.aws.s3.BucketPublicAccessBlockArgs.builder()
            .blockPublicAcls(blockPublicAcls?.applyValue({ args0 -> args0 }))
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .ignorePublicAcls(ignorePublicAcls?.applyValue({ args0 -> args0 }))
            .restrictPublicBuckets(restrictPublicBuckets?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketPublicAccessBlockArgs].
 */
@PulumiTagMarker
public class BucketPublicAccessBlockArgsBuilder internal constructor() {
    private var blockPublicAcls: Output<Boolean>? = null

    private var blockPublicPolicy: Output<Boolean>? = null

    private var bucket: Output<String>? = null

    private var ignorePublicAcls: Output<Boolean>? = null

    private var restrictPublicBuckets: Output<Boolean>? = null

    /**
     * @param value Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls will fail if the request includes an object ACL.
     */
    @JvmName("gjifqxpgiyxoduls")
    public suspend fun blockPublicAcls(`value`: Output<Boolean>) {
        this.blockPublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("nfqquksaraqmobbe")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value S3 Bucket to which this Public Access Block configuration should be applied.
     */
    @JvmName("jvhhiyfisqmlthxm")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore public ACLs on this bucket and any objects that it contains.
     */
    @JvmName("umoelmalckoomwqk")
    public suspend fun ignorePublicAcls(`value`: Output<Boolean>) {
        this.ignorePublicAcls = value
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
     */
    @JvmName("djovlkgetfkixwue")
    public suspend fun restrictPublicBuckets(`value`: Output<Boolean>) {
        this.restrictPublicBuckets = value
    }

    /**
     * @param value Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls will fail if the request includes an object ACL.
     */
    @JvmName("ivmlcnjylcufhfbg")
    public suspend fun blockPublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     */
    @JvmName("psqxmbjctsrpbchf")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value S3 Bucket to which this Public Access Block configuration should be applied.
     */
    @JvmName("ucyhnrssiovlwywi")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore public ACLs on this bucket and any objects that it contains.
     */
    @JvmName("uvnaxbipqhwknfgr")
    public suspend fun ignorePublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignorePublicAcls = mapped
    }

    /**
     * @param value Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
     */
    @JvmName("jjybvnyqcxtwqthg")
    public suspend fun restrictPublicBuckets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictPublicBuckets = mapped
    }

    internal fun build(): BucketPublicAccessBlockArgs = BucketPublicAccessBlockArgs(
        blockPublicAcls = blockPublicAcls,
        blockPublicPolicy = blockPublicPolicy,
        bucket = bucket,
        ignorePublicAcls = ignorePublicAcls,
        restrictPublicBuckets = restrictPublicBuckets,
    )
}
