@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRule
import com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketReplicationConfig].
 */
@PulumiTagMarker
public class BucketReplicationConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketReplicationConfigArgs = BucketReplicationConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketReplicationConfigArgsBuilder.() -> Unit) {
        val builder = BucketReplicationConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketReplicationConfig {
        val builtJavaResource = com.pulumi.aws.s3.BucketReplicationConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketReplicationConfig(builtJavaResource)
    }
}

/**
 * Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).
 * > **NOTE:** S3 Buckets only support a single replication configuration. Declaring multiple `aws.s3.BucketReplicationConfig` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Using replication configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var central = new Provider("central", ProviderArgs.builder()
 *             .region("eu-central-1")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("s3.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var replicationRole = new Role("replicationRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var destinationBucketV2 = new BucketV2("destinationBucketV2");
 *         var sourceBucketV2 = new BucketV2("sourceBucketV2", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.central())
 *             .build());
 *         final var replicationPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetReplicationConfiguration",
 *                         "s3:ListBucket")
 *                     .resources(sourceBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetObjectVersionForReplication",
 *                         "s3:GetObjectVersionAcl",
 *                         "s3:GetObjectVersionTagging")
 *                     .resources(sourceBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:ReplicateObject",
 *                         "s3:ReplicateDelete",
 *                         "s3:ReplicateTags")
 *                     .resources(destinationBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var replicationPolicy = new Policy("replicationPolicy", PolicyArgs.builder()
 *             .policy(replicationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(replicationPolicyDocument -> replicationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var replicationRolePolicyAttachment = new RolePolicyAttachment("replicationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(replicationRole.name())
 *             .policyArn(replicationPolicy.arn())
 *             .build());
 *         var destinationBucketVersioningV2 = new BucketVersioningV2("destinationBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(destinationBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var sourceBucketAcl = new BucketAclV2("sourceBucketAcl", BucketAclV2Args.builder()
 *             .bucket(sourceBucketV2.id())
 *             .acl("private")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 *         var sourceBucketVersioningV2 = new BucketVersioningV2("sourceBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(sourceBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 *         var replicationBucketReplicationConfig = new BucketReplicationConfig("replicationBucketReplicationConfig", BucketReplicationConfigArgs.builder()
 *             .role(replicationRole.arn())
 *             .bucket(sourceBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(destinationBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .dependsOn(sourceBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ### Bi-Directional Replication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eastBucketV2 = new BucketV2("eastBucketV2");
 *         var eastBucketVersioningV2 = new BucketVersioningV2("eastBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(eastBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var westBucketV2 = new BucketV2("westBucketV2", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.west())
 *             .build());
 *         var westBucketVersioningV2 = new BucketVersioningV2("westBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(westBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .build());
 *         var eastToWest = new BucketReplicationConfig("eastToWest", BucketReplicationConfigArgs.builder()
 *             .role(aws_iam_role.east_replication().arn())
 *             .bucket(eastBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(westBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(eastBucketVersioningV2)
 *                 .build());
 *         var westToEast = new BucketReplicationConfig("westToEast", BucketReplicationConfigArgs.builder()
 *             .role(aws_iam_role.west_replication().arn())
 *             .bucket(westBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(eastBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .dependsOn(westBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket replication configuration using the `bucket`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
 * ```
 * */*/
 */
public class BucketReplicationConfig internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketReplicationConfig,
) : KotlinCustomResource(javaResource, BucketReplicationConfigMapper) {
    /**
     * Name of the source S3 bucket you want Amazon S3 to monitor.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * List of configuration blocks describing the rules managing the replication. See below.
     */
    public val rules: Output<List<BucketReplicationConfigRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket's "Object Lock token".
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BucketReplicationConfigMapper : ResourceMapper<BucketReplicationConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketReplicationConfig::class == javaResource::class

    override fun map(javaResource: Resource): BucketReplicationConfig =
        BucketReplicationConfig(javaResource as com.pulumi.aws.s3.BucketReplicationConfig)
}

/**
 * @see [BucketReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketReplicationConfig].
 */
public suspend fun bucketReplicationConfig(
    name: String,
    block: suspend BucketReplicationConfigResourceBuilder.() -> Unit,
): BucketReplicationConfig {
    val builder = BucketReplicationConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketReplicationConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketReplicationConfig(name: String): BucketReplicationConfig {
    val builder = BucketReplicationConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
