@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketReplicationConfigArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketReplicationConfigRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketReplicationConfigRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).
 * > **NOTE:** S3 Buckets only support a single replication configuration. Declaring multiple `aws.s3.BucketReplicationConfig` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Using replication configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var central = new Provider("central", ProviderArgs.builder()
 *             .region("eu-central-1")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("s3.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var replicationRole = new Role("replicationRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var destinationBucketV2 = new BucketV2("destinationBucketV2");
 *         var sourceBucketV2 = new BucketV2("sourceBucketV2", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.central())
 *             .build());
 *         final var replicationPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetReplicationConfiguration",
 *                         "s3:ListBucket")
 *                     .resources(sourceBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetObjectVersionForReplication",
 *                         "s3:GetObjectVersionAcl",
 *                         "s3:GetObjectVersionTagging")
 *                     .resources(sourceBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:ReplicateObject",
 *                         "s3:ReplicateDelete",
 *                         "s3:ReplicateTags")
 *                     .resources(destinationBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var replicationPolicy = new Policy("replicationPolicy", PolicyArgs.builder()
 *             .policy(replicationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(replicationPolicyDocument -> replicationPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var replicationRolePolicyAttachment = new RolePolicyAttachment("replicationRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(replicationRole.name())
 *             .policyArn(replicationPolicy.arn())
 *             .build());
 *         var destinationBucketVersioningV2 = new BucketVersioningV2("destinationBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(destinationBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var sourceBucketAcl = new BucketAclV2("sourceBucketAcl", BucketAclV2Args.builder()
 *             .bucket(sourceBucketV2.id())
 *             .acl("private")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 *         var sourceBucketVersioningV2 = new BucketVersioningV2("sourceBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(sourceBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 *         var replicationBucketReplicationConfig = new BucketReplicationConfig("replicationBucketReplicationConfig", BucketReplicationConfigArgs.builder()
 *             .role(replicationRole.arn())
 *             .bucket(sourceBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(destinationBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .dependsOn(sourceBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ### Bi-Directional Replication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eastBucketV2 = new BucketV2("eastBucketV2");
 *         var eastBucketVersioningV2 = new BucketVersioningV2("eastBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(eastBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var westBucketV2 = new BucketV2("westBucketV2", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.west())
 *             .build());
 *         var westBucketVersioningV2 = new BucketVersioningV2("westBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(westBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .build());
 *         var eastToWest = new BucketReplicationConfig("eastToWest", BucketReplicationConfigArgs.builder()
 *             .role(aws_iam_role.east_replication().arn())
 *             .bucket(eastBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(westBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(eastBucketVersioningV2)
 *                 .build());
 *         var westToEast = new BucketReplicationConfig("westToEast", BucketReplicationConfigArgs.builder()
 *             .role(aws_iam_role.west_replication().arn())
 *             .bucket(westBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id("foobar")
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix("foo")
 *                     .build())
 *                 .status("Enabled")
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(eastBucketV2.arn())
 *                     .storageClass("STANDARD")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .dependsOn(westBucketVersioningV2)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket replication configuration using the `bucket`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
 * ```
 * @property bucket Name of the source S3 bucket you want Amazon S3 to monitor.
 * @property role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
 * @property rules List of configuration blocks describing the rules managing the replication. See below.
 * @property token Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket's "Object Lock token".
 * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
 * */*/
 */
public data class BucketReplicationConfigArgs(
    public val bucket: Output<String>? = null,
    public val role: Output<String>? = null,
    public val rules: Output<List<BucketReplicationConfigRuleArgs>>? = null,
    public val token: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketReplicationConfigArgs> {
    override fun toJava(): com.pulumi.aws.s3.BucketReplicationConfigArgs =
        com.pulumi.aws.s3.BucketReplicationConfigArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var role: Output<String>? = null

    private var rules: Output<List<BucketReplicationConfigRuleArgs>>? = null

    private var token: Output<String>? = null

    /**
     * @param value Name of the source S3 bucket you want Amazon S3 to monitor.
     */
    @JvmName("bjyrvkeudbqaiwkl")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("lvjovvlbdnyqavqv")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("ahobtrbrtwmjihxu")
    public suspend fun rules(`value`: Output<List<BucketReplicationConfigRuleArgs>>) {
        this.rules = value
    }

    @JvmName("ybqbrhfdvswtdhmv")
    public suspend fun rules(vararg values: Output<BucketReplicationConfigRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("xjrtsnxbgpajaupw")
    public suspend fun rules(values: List<Output<BucketReplicationConfigRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket's "Object Lock token".
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     */
    @JvmName("ihboymcupoicqbll")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Name of the source S3 bucket you want Amazon S3 to monitor.
     */
    @JvmName("cjdapjsddqoacykl")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("upmjopaflbmpaaib")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("cqqitcbdndoktymd")
    public suspend fun rules(`value`: List<BucketReplicationConfigRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("btbpbhnygeoyxtjv")
    public suspend
    fun rules(argument: List<suspend BucketReplicationConfigRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketReplicationConfigRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("rdhhuuipojhntvcm")
    public suspend fun rules(
        vararg
        argument: suspend BucketReplicationConfigRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketReplicationConfigRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("ttpvmngovfsptcad")
    public suspend fun rules(argument: suspend BucketReplicationConfigRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketReplicationConfigRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of configuration blocks describing the rules managing the replication. See below.
     */
    @JvmName("qeeigidmsvbrahjb")
    public suspend fun rules(vararg values: BucketReplicationConfigRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket's "Object Lock token".
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     */
    @JvmName("ccrjwmxlebbkcaac")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): BucketReplicationConfigArgs = BucketReplicationConfigArgs(
        bucket = bucket,
        role = role,
        rules = rules,
        token = token,
    )
}
