@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketRequestPaymentConfigurationV2].
 */
@PulumiTagMarker
public class BucketRequestPaymentConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketRequestPaymentConfigurationV2Args =
        BucketRequestPaymentConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend BucketRequestPaymentConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketRequestPaymentConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketRequestPaymentConfigurationV2 {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketRequestPaymentConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket request payment configuration resource. For more information, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html).
 * > **NOTE:** Destroying an `aws.s3.BucketRequestPaymentConfigurationV2` resource resets the bucket's `payer` to the S3 default: the bucket owner.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2;
 * import com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketRequestPaymentConfigurationV2("example", BucketRequestPaymentConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .payer("Requester")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket request payment configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketRequestPaymentConfigurationV2:BucketRequestPaymentConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketRequestPaymentConfigurationV2:BucketRequestPaymentConfigurationV2 example bucket-name,123456789012
 * ```
 *
 */
public class BucketRequestPaymentConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2,
) : KotlinCustomResource(javaResource, BucketRequestPaymentConfigurationV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
     */
    public val payer: Output<String>
        get() = javaResource.payer().applyValue({ args0 -> args0 })
}

public object BucketRequestPaymentConfigurationV2Mapper :
    ResourceMapper<BucketRequestPaymentConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketRequestPaymentConfigurationV2 =
        BucketRequestPaymentConfigurationV2(
            javaResource as
                com.pulumi.aws.s3.BucketRequestPaymentConfigurationV2,
        )
}

/**
 * @see [BucketRequestPaymentConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketRequestPaymentConfigurationV2].
 */
public suspend fun bucketRequestPaymentConfigurationV2(
    name: String,
    block: suspend BucketRequestPaymentConfigurationV2ResourceBuilder.() -> Unit,
):
    BucketRequestPaymentConfigurationV2 {
    val builder = BucketRequestPaymentConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketRequestPaymentConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketRequestPaymentConfigurationV2(name: String): BucketRequestPaymentConfigurationV2 {
    val builder = BucketRequestPaymentConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
