@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfigurationV2Rule
import com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfigurationV2Rule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketServerSideEncryptionConfigurationV2].
 */
@PulumiTagMarker
public class BucketServerSideEncryptionConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketServerSideEncryptionConfigurationV2Args =
        BucketServerSideEncryptionConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend BucketServerSideEncryptionConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketServerSideEncryptionConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketServerSideEncryptionConfigurationV2 {
        val builtJavaResource =
            com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketServerSideEncryptionConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket server-side encryption configuration resource.
 * > **NOTE:** Destroying an `aws.s3.BucketServerSideEncryptionConfigurationV2` resource resets the bucket to [Amazon S3 bucket default encryption](https://docs.aws.amazon.com/AmazonS3/latest/userguide/default-encryption-faq.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2;
 * import com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mykey = new Key("mykey", KeyArgs.builder()
 *             .description("This key is used to encrypt bucket objects")
 *             .deletionWindowInDays(10)
 *             .build());
 *         var mybucket = new BucketV2("mybucket");
 *         var example = new BucketServerSideEncryptionConfigurationV2("example", BucketServerSideEncryptionConfigurationV2Args.builder()
 *             .bucket(mybucket.id())
 *             .rules(BucketServerSideEncryptionConfigurationV2RuleArgs.builder()
 *                 .applyServerSideEncryptionByDefault(BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs.builder()
 *                     .kmsMasterKeyId(mykey.arn())
 *                     .sseAlgorithm("aws:kms")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket server-side encryption configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketServerSideEncryptionConfigurationV2:BucketServerSideEncryptionConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketServerSideEncryptionConfigurationV2:BucketServerSideEncryptionConfigurationV2 example bucket-name,123456789012
 * ```
 *
 */
public class BucketServerSideEncryptionConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2,
) : KotlinCustomResource(javaResource, BucketServerSideEncryptionConfigurationV2Mapper) {
    /**
     * ID (name) of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
     */
    public val rules: Output<List<BucketServerSideEncryptionConfigurationV2Rule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object BucketServerSideEncryptionConfigurationV2Mapper :
    ResourceMapper<BucketServerSideEncryptionConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketServerSideEncryptionConfigurationV2 =
        BucketServerSideEncryptionConfigurationV2(
            javaResource as
                com.pulumi.aws.s3.BucketServerSideEncryptionConfigurationV2,
        )
}

/**
 * @see [BucketServerSideEncryptionConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketServerSideEncryptionConfigurationV2].
 */
public suspend fun bucketServerSideEncryptionConfigurationV2(
    name: String,
    block: suspend BucketServerSideEncryptionConfigurationV2ResourceBuilder.() -> Unit,
):
    BucketServerSideEncryptionConfigurationV2 {
    val builder = BucketServerSideEncryptionConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketServerSideEncryptionConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketServerSideEncryptionConfigurationV2(name: String):
    BucketServerSideEncryptionConfigurationV2 {
    val builder = BucketServerSideEncryptionConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
