@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2CorsRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2CorsRuleArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2GrantArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2GrantArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2LifecycleRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2LifecycleRuleArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2LoggingArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2LoggingArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ObjectLockConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ObjectLockConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ReplicationConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ReplicationConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ServerSideEncryptionConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2ServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2VersioningArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2VersioningArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketV2WebsiteArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketV2WebsiteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket resource.
 * > This resource provides functionality for managing S3 general purpose buckets in an AWS Partition. To manage Amazon S3 Express directory buckets, use the `aws_directory_bucket` resource. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), use the `aws.s3control.Bucket` resource.
 * ## Example Usage
 * ### Private Bucket With Tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("Environment", "Dev"),
 *                 Map.entry("Name", "My bucket")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket using the `bucket`. For example:
 * ```sh
 *  $ pulumi import aws:s3/bucketV2:BucketV2 bucket bucket-name
 * ```
 * @property accelerationStatus Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
 * @property acl The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
 * @property bucket Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
 * @property bucketPrefix Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
 * @property corsRules Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
 * @property forceDestroy Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
 * @property grants An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
 * @property lifecycleRules Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
 * @property loggings Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketLoggingV2` instead.
 * @property objectLockConfiguration Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
 * The provider wil only perform drift detection if a configuration value is provided.
 * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
 * @property policy Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketPolicy` instead.
 * @property replicationConfigurations Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketReplicationConfig` instead.
 * @property requestPayer Specifies who should bear the cost of Amazon S3 data transfer.
 * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
 * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
 * @property serverSideEncryptionConfigurations Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
 * The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
 * @property tags Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The following arguments are deprecated, and will be removed in a future major version:
 * @property versionings Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
 * @property websites Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
 * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
 */
public data class BucketV2Args(
    @Deprecated(
        message = """
  Use the aws_s3_bucket_accelerate_configuration resource instead
  """,
    )
    public val accelerationStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val bucketPrefix: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    public val corsRules: Output<List<BucketV2CorsRuleArgs>>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    public val grants: Output<List<BucketV2GrantArgs>>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    public val lifecycleRules: Output<List<BucketV2LifecycleRuleArgs>>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    public val loggings: Output<List<BucketV2LoggingArgs>>? = null,
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration
      resource instead
  """,
    )
    public val objectLockConfiguration: Output<BucketV2ObjectLockConfigurationArgs>? = null,
    public val objectLockEnabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_policy resource instead
  """,
    )
    public val policy: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    public val replicationConfigurations: Output<List<BucketV2ReplicationConfigurationArgs>>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_request_payment_configuration resource instead
  """,
    )
    public val requestPayer: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    public val serverSideEncryptionConfigurations:
    Output<List<BucketV2ServerSideEncryptionConfigurationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    public val versionings: Output<List<BucketV2VersioningArgs>>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    public val websites: Output<List<BucketV2WebsiteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketV2Args = com.pulumi.aws.s3.BucketV2Args.builder()
        .accelerationStatus(accelerationStatus?.applyValue({ args0 -> args0 }))
        .acl(acl?.applyValue({ args0 -> args0 }))
        .bucket(bucket?.applyValue({ args0 -> args0 }))
        .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
        .corsRules(
            corsRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
        .grants(grants?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .lifecycleRules(
            lifecycleRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .loggings(
            loggings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .objectLockConfiguration(
            objectLockConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .objectLockEnabled(objectLockEnabled?.applyValue({ args0 -> args0 }))
        .policy(policy?.applyValue({ args0 -> args0 }))
        .replicationConfigurations(
            replicationConfigurations?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .requestPayer(requestPayer?.applyValue({ args0 -> args0 }))
        .serverSideEncryptionConfigurations(
            serverSideEncryptionConfigurations?.applyValue({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .versionings(
            versionings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .websites(
            websites?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [BucketV2Args].
 */
@PulumiTagMarker
public class BucketV2ArgsBuilder internal constructor() {
    private var accelerationStatus: Output<String>? = null

    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var corsRules: Output<List<BucketV2CorsRuleArgs>>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var grants: Output<List<BucketV2GrantArgs>>? = null

    private var lifecycleRules: Output<List<BucketV2LifecycleRuleArgs>>? = null

    private var loggings: Output<List<BucketV2LoggingArgs>>? = null

    private var objectLockConfiguration: Output<BucketV2ObjectLockConfigurationArgs>? = null

    private var objectLockEnabled: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var replicationConfigurations: Output<List<BucketV2ReplicationConfigurationArgs>>? = null

    private var requestPayer: Output<String>? = null

    private var serverSideEncryptionConfigurations:
        Output<List<BucketV2ServerSideEncryptionConfigurationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionings: Output<List<BucketV2VersioningArgs>>? = null

    private var websites: Output<List<BucketV2WebsiteArgs>>? = null

    /**
     * @param value Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_accelerate_configuration resource instead
  """,
    )
    @JvmName("ucgfnwjrynkaigaq")
    public suspend fun accelerationStatus(`value`: Output<String>) {
        this.accelerationStatus = value
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("qbbnhilrqgedmqin")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
     */
    @JvmName("pikpdcpsbuoupayw")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    @JvmName("uqkkksrepfejcxra")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("fnkwtadiiidexanv")
    public suspend fun corsRules(`value`: Output<List<BucketV2CorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("mwuysmfhtbjhibrm")
    public suspend fun corsRules(vararg values: Output<BucketV2CorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("fhtjbmhstcvcjimy")
    public suspend fun corsRules(values: List<Output<BucketV2CorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("fsfbokbjjdsgisdu")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("ybuiwssvsjjfpiom")
    public suspend fun grants(`value`: Output<List<BucketV2GrantArgs>>) {
        this.grants = value
    }

    @JvmName("kysgycjkswegknrb")
    public suspend fun grants(vararg values: Output<BucketV2GrantArgs>) {
        this.grants = Output.all(values.asList())
    }

    /**
     * @param values An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("rwoesegymqkmuiiv")
    public suspend fun grants(values: List<Output<BucketV2GrantArgs>>) {
        this.grants = Output.all(values)
    }

    /**
     * @param value Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("skityynxoxhhnvha")
    public suspend fun lifecycleRules(`value`: Output<List<BucketV2LifecycleRuleArgs>>) {
        this.lifecycleRules = value
    }

    @JvmName("qvjckiifexwxhnvq")
    public suspend fun lifecycleRules(vararg values: Output<BucketV2LifecycleRuleArgs>) {
        this.lifecycleRules = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("kvfrrwxdjknmlnya")
    public suspend fun lifecycleRules(values: List<Output<BucketV2LifecycleRuleArgs>>) {
        this.lifecycleRules = Output.all(values)
    }

    /**
     * @param value Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("ssfxpghkliqdveqh")
    public suspend fun loggings(`value`: Output<List<BucketV2LoggingArgs>>) {
        this.loggings = value
    }

    @JvmName("ydhsgrldfuiyxjcb")
    public suspend fun loggings(vararg values: Output<BucketV2LoggingArgs>) {
        this.loggings = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("gpoewtmhlpkvisem")
    public suspend fun loggings(values: List<Output<BucketV2LoggingArgs>>) {
        this.loggings = Output.all(values)
    }

    /**
     * @param value Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration
      resource instead
  """,
    )
    @JvmName("yioqyioayeqspnpw")
    public suspend fun objectLockConfiguration(`value`: Output<BucketV2ObjectLockConfigurationArgs>) {
        this.objectLockConfiguration = value
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @JvmName("uqyxkxbkglgujflr")
    public suspend fun objectLockEnabled(`value`: Output<Boolean>) {
        this.objectLockEnabled = value
    }

    /**
     * @param value Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_policy resource instead
  """,
    )
    @JvmName("cxpaaaqgvuajpmex")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("rwgbxqplrobitbxd")
    public suspend
    fun replicationConfigurations(`value`: Output<List<BucketV2ReplicationConfigurationArgs>>) {
        this.replicationConfigurations = value
    }

    @JvmName("rvytrsmviiuunkeu")
    public suspend fun replicationConfigurations(
        vararg
        values: Output<BucketV2ReplicationConfigurationArgs>,
    ) {
        this.replicationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("ihtksulnabdblomh")
    public suspend
    fun replicationConfigurations(values: List<Output<BucketV2ReplicationConfigurationArgs>>) {
        this.replicationConfigurations = Output.all(values)
    }

    /**
     * @param value Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_request_payment_configuration resource instead
  """,
    )
    @JvmName("vevhtggxngehybld")
    public suspend fun requestPayer(`value`: Output<String>) {
        this.requestPayer = value
    }

    /**
     * @param value Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("ypijggwjtuictvqq")
    public suspend
    fun serverSideEncryptionConfigurations(`value`: Output<List<BucketV2ServerSideEncryptionConfigurationArgs>>) {
        this.serverSideEncryptionConfigurations = value
    }

    @JvmName("lqaofitobcnehyjj")
    public suspend fun serverSideEncryptionConfigurations(
        vararg
        values: Output<BucketV2ServerSideEncryptionConfigurationArgs>,
    ) {
        this.serverSideEncryptionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("ciruywqesokpalkh")
    public suspend
    fun serverSideEncryptionConfigurations(values: List<Output<BucketV2ServerSideEncryptionConfigurationArgs>>) {
        this.serverSideEncryptionConfigurations = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("ruodcxvwvwcopiba")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("lbtjodbmtmbemdxl")
    public suspend fun versionings(`value`: Output<List<BucketV2VersioningArgs>>) {
        this.versionings = value
    }

    @JvmName("uesjfkdbcifcrbjv")
    public suspend fun versionings(vararg values: Output<BucketV2VersioningArgs>) {
        this.versionings = Output.all(values.asList())
    }

    /**
     * @param values Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("mtkdsxweaydltgtw")
    public suspend fun versionings(values: List<Output<BucketV2VersioningArgs>>) {
        this.versionings = Output.all(values)
    }

    /**
     * @param value Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("trhskvflkfjxwini")
    public suspend fun websites(`value`: Output<List<BucketV2WebsiteArgs>>) {
        this.websites = value
    }

    @JvmName("umkalecvypmeaxdv")
    public suspend fun websites(vararg values: Output<BucketV2WebsiteArgs>) {
        this.websites = Output.all(values.asList())
    }

    /**
     * @param values Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("hxjfstkdhnkycusg")
    public suspend fun websites(values: List<Output<BucketV2WebsiteArgs>>) {
        this.websites = Output.all(values)
    }

    /**
     * @param value Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_accelerate_configuration resource instead
  """,
    )
    @JvmName("mhgbbulphwtnyled")
    public suspend fun accelerationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerationStatus = mapped
    }

    /**
     * @param value The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("cwmrvttvyrjaumqb")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs&#46;aws&#46;amazon&#46;com/AmazonS3/latest/userguide/bucketnamingrules&#46;html)&#46; The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.DirectoryBucket` resource to manage S3 Express buckets.
     */
    @JvmName("aqbrihtkwajyyqhk")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     */
    @JvmName("nsumqihvdosklyeh")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("eslujknywlkxfgmq")
    public suspend fun corsRules(`value`: List<BucketV2CorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("yydyxhssopboadii")
    public suspend fun corsRules(argument: List<suspend BucketV2CorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2CorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("inlgixeurtrymibv")
    public suspend fun corsRules(vararg argument: suspend BucketV2CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2CorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("wkswffqucfkuvmmt")
    public suspend fun corsRules(argument: suspend BucketV2CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2CorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_cors_configuration resource instead
  """,
    )
    @JvmName("nsdyrwstrdaiowng")
    public suspend fun corsRules(vararg values: BucketV2CorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param value Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    @JvmName("uoxuuyarrvmilqyv")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("ntwurxssjteoqayi")
    public suspend fun grants(`value`: List<BucketV2GrantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("mumceldeacbscrgs")
    public suspend fun grants(argument: List<suspend BucketV2GrantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2GrantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("ucofmvjyhwamtqdf")
    public suspend fun grants(vararg argument: suspend BucketV2GrantArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2GrantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param argument An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("ajbuxwlvsasrkwha")
    public suspend fun grants(argument: suspend BucketV2GrantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2GrantArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.grants = mapped
    }

    /**
     * @param values An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_acl resource instead
  """,
    )
    @JvmName("cjvvilicctyqgjth")
    public suspend fun grants(vararg values: BucketV2GrantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grants = mapped
    }

    /**
     * @param value Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("mdpsqsdwropamxix")
    public suspend fun lifecycleRules(`value`: List<BucketV2LifecycleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("kbencvouhiseyepy")
    public suspend
    fun lifecycleRules(argument: List<suspend BucketV2LifecycleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("tltedoyuwumnlgjo")
    public suspend fun lifecycleRules(
        vararg
        argument: suspend BucketV2LifecycleRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("ppdrxbobyhfxqrlv")
    public suspend fun lifecycleRules(argument: suspend BucketV2LifecycleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2LifecycleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param values Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_lifecycle_configuration resource instead
  """,
    )
    @JvmName("shdjaeljruvdnjrk")
    public suspend fun lifecycleRules(vararg values: BucketV2LifecycleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param value Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("urjyypthnmvtoxoe")
    public suspend fun loggings(`value`: List<BucketV2LoggingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("quskhmianocwdpxa")
    public suspend fun loggings(argument: List<suspend BucketV2LoggingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LoggingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("fjlbakxlssoenxvg")
    public suspend fun loggings(vararg argument: suspend BucketV2LoggingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2LoggingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param argument Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("omytrkofnrbcytdg")
    public suspend fun loggings(argument: suspend BucketV2LoggingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2LoggingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loggings = mapped
    }

    /**
     * @param values Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_logging resource instead
  """,
    )
    @JvmName("jqmtfynipevlcjwc")
    public suspend fun loggings(vararg values: BucketV2LoggingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggings = mapped
    }

    /**
     * @param value Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration
      resource instead
  """,
    )
    @JvmName("jutjwthttbibikow")
    public suspend fun objectLockConfiguration(`value`: BucketV2ObjectLockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockConfiguration = mapped
    }

    /**
     * @param argument Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration
      resource instead
  """,
    )
    @JvmName("llfocpfjxvhkseoo")
    public suspend
    fun objectLockConfiguration(argument: suspend BucketV2ObjectLockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketV2ObjectLockConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.objectLockConfiguration = mapped
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @JvmName("vdyfkeslpdnsohhr")
    public suspend fun objectLockEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockEnabled = mapped
    }

    /**
     * @param value Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_policy resource instead
  """,
    )
    @JvmName("ehygdonkedmnqjic")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("ygyfoyjfsnwgkcsy")
    public suspend
    fun replicationConfigurations(`value`: List<BucketV2ReplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationConfigurations = mapped
    }

    /**
     * @param argument Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("gfgpxrtcjyhnaqnb")
    public suspend
    fun replicationConfigurations(argument: List<suspend BucketV2ReplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationConfigurations = mapped
    }

    /**
     * @param argument Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("ltyeedpeputnwyyo")
    public suspend fun replicationConfigurations(
        vararg
        argument: suspend BucketV2ReplicationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationConfigurations = mapped
    }

    /**
     * @param argument Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("caucadlmadoohxkn")
    public suspend
    fun replicationConfigurations(argument: suspend BucketV2ReplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ReplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.replicationConfigurations = mapped
    }

    /**
     * @param values Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_replication_configuration resource instead
  """,
    )
    @JvmName("dodepnsmstesvssa")
    public suspend fun replicationConfigurations(
        vararg
        values: BucketV2ReplicationConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationConfigurations = mapped
    }

    /**
     * @param value Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_request_payment_configuration resource instead
  """,
    )
    @JvmName("gffxfpapfcnlsfnl")
    public suspend fun requestPayer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestPayer = mapped
    }

    /**
     * @param value Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("nitbwddgfolbdger")
    public suspend
    fun serverSideEncryptionConfigurations(`value`: List<BucketV2ServerSideEncryptionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfigurations = mapped
    }

    /**
     * @param argument Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("xfrivfxppwjrfadu")
    public suspend
    fun serverSideEncryptionConfigurations(argument: List<suspend BucketV2ServerSideEncryptionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfigurations = mapped
    }

    /**
     * @param argument Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("tjrabjtpkucasmnj")
    public suspend fun serverSideEncryptionConfigurations(
        vararg
        argument: suspend BucketV2ServerSideEncryptionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfigurations = mapped
    }

    /**
     * @param argument Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("crrciwhpqducrqhf")
    public suspend
    fun serverSideEncryptionConfigurations(argument: suspend BucketV2ServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ServerSideEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfigurations = mapped
    }

    /**
     * @param values Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_server_side_encryption_configuration resource instead
  """,
    )
    @JvmName("wroqwepoojcqxuyn")
    public suspend fun serverSideEncryptionConfigurations(
        vararg
        values: BucketV2ServerSideEncryptionConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfigurations = mapped
    }

    /**
     * @param value Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("ljdtldnoqxxvypqx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The following arguments are deprecated, and will be removed in a future major version:
     */
    @JvmName("njwusovpcjqultop")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("tnuhttupoiaoueeq")
    public suspend fun versionings(`value`: List<BucketV2VersioningArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionings = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("lhfpangyywdekimh")
    public suspend fun versionings(argument: List<suspend BucketV2VersioningArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2VersioningArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.versionings = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("ugbovctkxycnkpjt")
    public suspend fun versionings(
        vararg
        argument: suspend BucketV2VersioningArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2VersioningArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.versionings = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("cqgqstgjaybwqkma")
    public suspend fun versionings(argument: suspend BucketV2VersioningArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2VersioningArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.versionings = mapped
    }

    /**
     * @param values Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_versioning resource instead
  """,
    )
    @JvmName("qqvdqnahqvpmqdat")
    public suspend fun versionings(vararg values: BucketV2VersioningArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionings = mapped
    }

    /**
     * @param value Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("dkfgiocglqmdcskj")
    public suspend fun websites(`value`: List<BucketV2WebsiteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websites = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("tcudoqnguebftsgj")
    public suspend fun websites(argument: List<suspend BucketV2WebsiteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2WebsiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.websites = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("vywceoucmqxpslcp")
    public suspend fun websites(vararg argument: suspend BucketV2WebsiteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2WebsiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.websites = mapped
    }

    /**
     * @param argument Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("mwjcbwtcaaafqtdv")
    public suspend fun websites(argument: suspend BucketV2WebsiteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketV2WebsiteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.websites = mapped
    }

    /**
     * @param values Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_website_configuration resource instead
  """,
    )
    @JvmName("efyjeohnrvbbfvdk")
    public suspend fun websites(vararg values: BucketV2WebsiteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.websites = mapped
    }

    internal fun build(): BucketV2Args = BucketV2Args(
        accelerationStatus = accelerationStatus,
        acl = acl,
        bucket = bucket,
        bucketPrefix = bucketPrefix,
        corsRules = corsRules,
        forceDestroy = forceDestroy,
        grants = grants,
        lifecycleRules = lifecycleRules,
        loggings = loggings,
        objectLockConfiguration = objectLockConfiguration,
        objectLockEnabled = objectLockEnabled,
        policy = policy,
        replicationConfigurations = replicationConfigurations,
        requestPayer = requestPayer,
        serverSideEncryptionConfigurations = serverSideEncryptionConfigurations,
        tags = tags,
        versionings = versionings,
        websites = websites,
    )
}
