@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketVersioningV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketVersioningV2VersioningConfigurationArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketVersioningV2VersioningConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource for controlling versioning on an S3 bucket.
 * Deleting this resource will either suspend versioning on the associated S3 bucket or
 * simply remove the resource from state if the associated S3 bucket is unversioned.
 * For more information, see [How S3 versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html).
 * > **NOTE:** If you are enabling versioning on the bucket for the first time, AWS recommends that you wait for 15 minutes after enabling versioning before issuing write operations (PUT or DELETE) on objects in the bucket.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With Versioning Enabled
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var versioningExample = new BucketVersioningV2("versioningExample", BucketVersioningV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Versioning Disabled
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var versioningExample = new BucketVersioningV2("versioningExample", BucketVersioningV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Disabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Object Dependency On Versioning
 * When you create an object whose `version_id` you need and an `aws.s3.BucketVersioningV2` resource in the same configuration, you are more likely to have success by ensuring the `s3_object` depends either implicitly (see below) or explicitly (i.e., using `depends_on = [aws_s3_bucket_versioning.example]`) on the `aws.s3.BucketVersioningV2` resource.
 * > **NOTE:** For critical and/or production S3 objects, do not create a bucket, enable versioning, and create an object in the bucket within the same configuration. Doing so will not allow the AWS-recommended 15 minutes between enabling versioning and writing to the bucket.
 * This example shows the `aws_s3_object.example` depending implicitly on the versioning resource through the reference to `aws_s3_bucket_versioning.example.bucket` to define `bucket`:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketVersioningV2 = new BucketVersioningV2("exampleBucketVersioningV2", BucketVersioningV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketVersioningV2.id())
 *             .key("droeloe")
 *             .source(new FileAsset("example.txt"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket versioning using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketVersioningV2:BucketVersioningV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketVersioningV2:BucketVersioningV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the S3 bucket.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property mfa Concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.
 * @property versioningConfiguration Configuration block for the versioning parameters. See below.
 */
public data class BucketVersioningV2Args(
    public val bucket: Output<String>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val mfa: Output<String>? = null,
    public val versioningConfiguration: Output<BucketVersioningV2VersioningConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketVersioningV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketVersioningV2Args =
        com.pulumi.aws.s3.BucketVersioningV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .mfa(mfa?.applyValue({ args0 -> args0 }))
            .versioningConfiguration(
                versioningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketVersioningV2Args].
 */
@PulumiTagMarker
public class BucketVersioningV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var mfa: Output<String>? = null

    private var versioningConfiguration: Output<BucketVersioningV2VersioningConfigurationArgs>? = null

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("khpromdbunhgaoow")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("utwhckrvermyqhyq")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.
     */
    @JvmName("snsbxlalincvrath")
    public suspend fun mfa(`value`: Output<String>) {
        this.mfa = value
    }

    /**
     * @param value Configuration block for the versioning parameters. See below.
     */
    @JvmName("xbxlqgxkwhlgqgur")
    public suspend
    fun versioningConfiguration(`value`: Output<BucketVersioningV2VersioningConfigurationArgs>) {
        this.versioningConfiguration = value
    }

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("uvqcrmimikrurmje")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("vrwxuvhwyvfayimr")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.
     */
    @JvmName("abnufscqdtsupqej")
    public suspend fun mfa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfa = mapped
    }

    /**
     * @param value Configuration block for the versioning parameters. See below.
     */
    @JvmName("mmamtjvobriwvbbv")
    public suspend
    fun versioningConfiguration(`value`: BucketVersioningV2VersioningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioningConfiguration = mapped
    }

    /**
     * @param argument Configuration block for the versioning parameters. See below.
     */
    @JvmName("ogkensxnfnywcbac")
    public suspend
    fun versioningConfiguration(argument: suspend BucketVersioningV2VersioningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketVersioningV2VersioningConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.versioningConfiguration = mapped
    }

    internal fun build(): BucketVersioningV2Args = BucketVersioningV2Args(
        bucket = bucket,
        expectedBucketOwner = expectedBucketOwner,
        mfa = mfa,
        versioningConfiguration = versioningConfiguration,
    )
}
