@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2ErrorDocument
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2IndexDocument
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RedirectAllRequestsTo
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RoutingRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2ErrorDocument.Companion.toKotlin as bucketWebsiteConfigurationV2ErrorDocumentToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2IndexDocument.Companion.toKotlin as bucketWebsiteConfigurationV2IndexDocumentToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RedirectAllRequestsTo.Companion.toKotlin as bucketWebsiteConfigurationV2RedirectAllRequestsToToKotlin
import com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RoutingRule.Companion.toKotlin as bucketWebsiteConfigurationV2RoutingRuleToKotlin

/**
 * Builder for [BucketWebsiteConfigurationV2].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketWebsiteConfigurationV2Args = BucketWebsiteConfigurationV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketWebsiteConfigurationV2ArgsBuilder.() -> Unit) {
        val builder = BucketWebsiteConfigurationV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketWebsiteConfigurationV2 {
        val builtJavaResource = com.pulumi.aws.s3.BucketWebsiteConfigurationV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketWebsiteConfigurationV2(builtJavaResource)
    }
}

/**
 * Provides an S3 bucket website configuration resource. For more information, see [Hosting Websites on S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With `routing_rule` configured
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2("example", BucketWebsiteConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix("index.html")
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key("error.html")
 *                 .build())
 *             .routingRules(BucketWebsiteConfigurationV2RoutingRuleArgs.builder()
 *                 .condition(BucketWebsiteConfigurationV2RoutingRuleConditionArgs.builder()
 *                     .keyPrefixEquals("docs/")
 *                     .build())
 *                 .redirect(BucketWebsiteConfigurationV2RoutingRuleRedirectArgs.builder()
 *                     .replaceKeyPrefixWith("documents/")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With `routing_rules` configured
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2("example", BucketWebsiteConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix("index.html")
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key("error.html")
 *                 .build())
 *             .routingRuleDetails("""
 * [{
 *     "Condition": {
 *         "KeyPrefixEquals": "docs/"
 *     },
 *     "Redirect": {
 *         "ReplaceKeyPrefixWith": ""
 *     }
 * }]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket website configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name,123456789012
 * ```
 *
 */
public class BucketWebsiteConfigurationV2 internal constructor(
    override val javaResource: com.pulumi.aws.s3.BucketWebsiteConfigurationV2,
) : KotlinCustomResource(javaResource, BucketWebsiteConfigurationV2Mapper) {
    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Name of the error document for the website. See below.
     */
    public val errorDocument: Output<BucketWebsiteConfigurationV2ErrorDocument>?
        get() = javaResource.errorDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteConfigurationV2ErrorDocumentToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Account ID of the expected bucket owner.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the index document for the website. See below.
     */
    public val indexDocument: Output<BucketWebsiteConfigurationV2IndexDocument>?
        get() = javaResource.indexDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteConfigurationV2IndexDocumentToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Redirect behavior for every request to this bucket's website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     */
    public val redirectAllRequestsTo: Output<BucketWebsiteConfigurationV2RedirectAllRequestsTo>?
        get() = javaResource.redirectAllRequestsTo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteConfigurationV2RedirectAllRequestsToToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`""`) as seen in the example above.
     */
    public val routingRuleDetails: Output<String>
        get() = javaResource.routingRuleDetails().applyValue({ args0 -> args0 })

    /**
     * List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    public val routingRules: Output<List<BucketWebsiteConfigurationV2RoutingRule>>
        get() = javaResource.routingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteConfigurationV2RoutingRuleToKotlin(args0)
                })
            })
        })

    /**
     * Domain of the website endpoint. This is used to create Route 53 alias records.
     */
    public val websiteDomain: Output<String>
        get() = javaResource.websiteDomain().applyValue({ args0 -> args0 })

    /**
     * Website endpoint.
     */
    public val websiteEndpoint: Output<String>
        get() = javaResource.websiteEndpoint().applyValue({ args0 -> args0 })
}

public object BucketWebsiteConfigurationV2Mapper : ResourceMapper<BucketWebsiteConfigurationV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.BucketWebsiteConfigurationV2::class == javaResource::class

    override fun map(javaResource: Resource): BucketWebsiteConfigurationV2 =
        BucketWebsiteConfigurationV2(javaResource as com.pulumi.aws.s3.BucketWebsiteConfigurationV2)
}

/**
 * @see [BucketWebsiteConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketWebsiteConfigurationV2].
 */
public suspend fun bucketWebsiteConfigurationV2(
    name: String,
    block: suspend BucketWebsiteConfigurationV2ResourceBuilder.() -> Unit,
):
    BucketWebsiteConfigurationV2 {
    val builder = BucketWebsiteConfigurationV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketWebsiteConfigurationV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketWebsiteConfigurationV2(name: String): BucketWebsiteConfigurationV2 {
    val builder = BucketWebsiteConfigurationV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
