@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args.builder
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2IndexDocumentArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs
import com.pulumi.aws.s3.kotlin.inputs.BucketWebsiteConfigurationV2RoutingRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an S3 bucket website configuration resource. For more information, see [Hosting Websites on S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### With `routing_rule` configured
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2("example", BucketWebsiteConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix("index.html")
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key("error.html")
 *                 .build())
 *             .routingRules(BucketWebsiteConfigurationV2RoutingRuleArgs.builder()
 *                 .condition(BucketWebsiteConfigurationV2RoutingRuleConditionArgs.builder()
 *                     .keyPrefixEquals("docs/")
 *                     .build())
 *                 .redirect(BucketWebsiteConfigurationV2RoutingRuleRedirectArgs.builder()
 *                     .replaceKeyPrefixWith("documents/")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With `routing_rules` configured
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2("example", BucketWebsiteConfigurationV2Args.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix("index.html")
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key("error.html")
 *                 .build())
 *             .routingRuleDetails("""
 * [{
 *     "Condition": {
 *         "KeyPrefixEquals": "docs/"
 *     },
 *     "Redirect": {
 *         "ReplaceKeyPrefixWith": ""
 *     }
 * }]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * __Using `pulumi import` to import__ S3 bucket website configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name,123456789012
 * ```
 * @property bucket Name of the bucket.
 * @property errorDocument Name of the error document for the website. See below.
 * @property expectedBucketOwner Account ID of the expected bucket owner.
 * @property indexDocument Name of the index document for the website. See below.
 * @property redirectAllRequestsTo Redirect behavior for every request to this bucket's website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
 * @property routingRuleDetails JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
 * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`""`) as seen in the example above.
 * @property routingRules List of rules that define when a redirect is applied and the redirect behavior. See below.
 */
public data class BucketWebsiteConfigurationV2Args(
    public val bucket: Output<String>? = null,
    public val errorDocument: Output<BucketWebsiteConfigurationV2ErrorDocumentArgs>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val indexDocument: Output<BucketWebsiteConfigurationV2IndexDocumentArgs>? = null,
    public val redirectAllRequestsTo: Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs>? =
        null,
    public val routingRuleDetails: Output<String>? = null,
    public val routingRules: Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args> {
    override fun toJava(): com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args =
        com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .errorDocument(errorDocument?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .indexDocument(indexDocument?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redirectAllRequestsTo(
                redirectAllRequestsTo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingRuleDetails(routingRuleDetails?.applyValue({ args0 -> args0 }))
            .routingRules(
                routingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2Args].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var errorDocument: Output<BucketWebsiteConfigurationV2ErrorDocumentArgs>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var indexDocument: Output<BucketWebsiteConfigurationV2IndexDocumentArgs>? = null

    private var redirectAllRequestsTo: Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs>? =
        null

    private var routingRuleDetails: Output<String>? = null

    private var routingRules: Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>>? = null

    /**
     * @param value Name of the bucket.
     */
    @JvmName("jqfpgwomkxcifjrc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Name of the error document for the website. See below.
     */
    @JvmName("bwpbcbfgaqulllrm")
    public suspend fun errorDocument(`value`: Output<BucketWebsiteConfigurationV2ErrorDocumentArgs>) {
        this.errorDocument = value
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("ghregksnuilbwmyy")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Name of the index document for the website. See below.
     */
    @JvmName("dkhvyqoxyctydowo")
    public suspend fun indexDocument(`value`: Output<BucketWebsiteConfigurationV2IndexDocumentArgs>) {
        this.indexDocument = value
    }

    /**
     * @param value Redirect behavior for every request to this bucket's website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     */
    @JvmName("ycldnmguxoadounq")
    public suspend
    fun redirectAllRequestsTo(`value`: Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs>) {
        this.redirectAllRequestsTo = value
    }

    /**
     * @param value JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`""`) as seen in the example above.
     */
    @JvmName("uqbdjxkkpcjktsyk")
    public suspend fun routingRuleDetails(`value`: Output<String>) {
        this.routingRuleDetails = value
    }

    /**
     * @param value List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("nqirmvvjghgqxynp")
    public suspend
    fun routingRules(`value`: Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>>) {
        this.routingRules = value
    }

    @JvmName("lbtkkmbkqvioxwde")
    public suspend fun routingRules(
        vararg
        values: Output<BucketWebsiteConfigurationV2RoutingRuleArgs>,
    ) {
        this.routingRules = Output.all(values.asList())
    }

    /**
     * @param values List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("bluaclwrubtyhbty")
    public suspend
    fun routingRules(values: List<Output<BucketWebsiteConfigurationV2RoutingRuleArgs>>) {
        this.routingRules = Output.all(values)
    }

    /**
     * @param value Name of the bucket.
     */
    @JvmName("pexubqxhoaekcrfe")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Name of the error document for the website. See below.
     */
    @JvmName("mhabmivasjvkitdv")
    public suspend fun errorDocument(`value`: BucketWebsiteConfigurationV2ErrorDocumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorDocument = mapped
    }

    /**
     * @param argument Name of the error document for the website. See below.
     */
    @JvmName("bvvmepstkekeitlb")
    public suspend
    fun errorDocument(argument: suspend BucketWebsiteConfigurationV2ErrorDocumentArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteConfigurationV2ErrorDocumentArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.errorDocument = mapped
    }

    /**
     * @param value Account ID of the expected bucket owner.
     */
    @JvmName("sakgluwdrwawqygc")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Name of the index document for the website. See below.
     */
    @JvmName("vbsijeaajshfysxd")
    public suspend fun indexDocument(`value`: BucketWebsiteConfigurationV2IndexDocumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexDocument = mapped
    }

    /**
     * @param argument Name of the index document for the website. See below.
     */
    @JvmName("orpuuxkfcnxesyfg")
    public suspend
    fun indexDocument(argument: suspend BucketWebsiteConfigurationV2IndexDocumentArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteConfigurationV2IndexDocumentArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.indexDocument = mapped
    }

    /**
     * @param value Redirect behavior for every request to this bucket's website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     */
    @JvmName("rqmmouacarshasxf")
    public suspend
    fun redirectAllRequestsTo(`value`: BucketWebsiteConfigurationV2RedirectAllRequestsToArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectAllRequestsTo = mapped
    }

    /**
     * @param argument Redirect behavior for every request to this bucket's website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     */
    @JvmName("utfdndqockpbchgo")
    public suspend
    fun redirectAllRequestsTo(argument: suspend BucketWebsiteConfigurationV2RedirectAllRequestsToArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteConfigurationV2RedirectAllRequestsToArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redirectAllRequestsTo = mapped
    }

    /**
     * @param value JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`""`) as seen in the example above.
     */
    @JvmName("ocbmxbupsfkfftmd")
    public suspend fun routingRuleDetails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRuleDetails = mapped
    }

    /**
     * @param value List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("vshlgekjnjdpanev")
    public suspend fun routingRules(`value`: List<BucketWebsiteConfigurationV2RoutingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param argument List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("ntlfmqqwddhjuipw")
    public suspend
    fun routingRules(argument: List<suspend BucketWebsiteConfigurationV2RoutingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketWebsiteConfigurationV2RoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("wlussdmmylawjiei")
    public suspend fun routingRules(
        vararg
        argument: suspend BucketWebsiteConfigurationV2RoutingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketWebsiteConfigurationV2RoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("ueefmsnemmskljxs")
    public suspend
    fun routingRules(argument: suspend BucketWebsiteConfigurationV2RoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketWebsiteConfigurationV2RoutingRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param values List of rules that define when a redirect is applied and the redirect behavior. See below.
     */
    @JvmName("nhdhukktkbpxbbdb")
    public suspend fun routingRules(vararg values: BucketWebsiteConfigurationV2RoutingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2Args = BucketWebsiteConfigurationV2Args(
        bucket = bucket,
        errorDocument = errorDocument,
        expectedBucketOwner = expectedBucketOwner,
        indexDocument = indexDocument,
        redirectAllRequestsTo = redirectAllRequestsTo,
        routingRuleDetails = routingRuleDetails,
        routingRules = routingRules,
    )
}
