@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.DirectoryBucketLocation
import com.pulumi.aws.s3.kotlin.outputs.DirectoryBucketLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DirectoryBucket].
 */
@PulumiTagMarker
public class DirectoryBucketResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DirectoryBucketArgs = DirectoryBucketArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DirectoryBucketArgsBuilder.() -> Unit) {
        val builder = DirectoryBucketArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DirectoryBucket {
        val builtJavaResource = com.pulumi.aws.s3.DirectoryBucket(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DirectoryBucket(builtJavaResource)
    }
}

/**
 * Provides an Amazon S3 Express directory bucket resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.DirectoryBucket;
 * import com.pulumi.aws.s3.DirectoryBucketArgs;
 * import com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DirectoryBucket("example", DirectoryBucketArgs.builder()
 *             .bucket("example--usw2-az1--x-s3")
 *             .location(DirectoryBucketLocationArgs.builder()
 *                 .name("usw2-az1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket using `bucket`. For example:
 * ```sh
 *  $ pulumi import aws:s3/directoryBucket:DirectoryBucket example example--usw2-az1--x-s3
 * ```
 *
 */
public class DirectoryBucket internal constructor(
    override val javaResource: com.pulumi.aws.s3.DirectoryBucket,
) : KotlinCustomResource(javaResource, DirectoryBucketMapper) {
    /**
     * ARN of the bucket.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `aws.s3.BucketV2` resource to manage general purpose buckets.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Data redundancy. Valid values: `SingleAvailabilityZone`.
     */
    public val dataRedundancy: Output<String>
        get() = javaResource.dataRedundancy().applyValue({ args0 -> args0 })

    /**
     * Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     */
    public val forceDestroy: Output<Boolean>
        get() = javaResource.forceDestroy().applyValue({ args0 -> args0 })

    /**
     * Bucket location. See Location below for more details.
     */
    public val location: Output<DirectoryBucketLocation>?
        get() = javaResource.location().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Bucket type. Valid values: `Directory`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DirectoryBucketMapper : ResourceMapper<DirectoryBucket> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.DirectoryBucket::class == javaResource::class

    override fun map(javaResource: Resource): DirectoryBucket = DirectoryBucket(
        javaResource as
            com.pulumi.aws.s3.DirectoryBucket,
    )
}

/**
 * @see [DirectoryBucket].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DirectoryBucket].
 */
public suspend fun directoryBucket(
    name: String,
    block: suspend DirectoryBucketResourceBuilder.() -> Unit,
): DirectoryBucket {
    val builder = DirectoryBucketResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DirectoryBucket].
 * @param name The _unique_ name of the resulting resource.
 */
public fun directoryBucket(name: String): DirectoryBucket {
    val builder = DirectoryBucketResourceBuilder()
    builder.name(name)
    return builder.build()
}
