@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.kotlin.outputs.InventoryDestination
import com.pulumi.aws.s3.kotlin.outputs.InventoryFilter
import com.pulumi.aws.s3.kotlin.outputs.InventorySchedule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.s3.kotlin.outputs.InventoryDestination.Companion.toKotlin as inventoryDestinationToKotlin
import com.pulumi.aws.s3.kotlin.outputs.InventoryFilter.Companion.toKotlin as inventoryFilterToKotlin
import com.pulumi.aws.s3.kotlin.outputs.InventorySchedule.Companion.toKotlin as inventoryScheduleToKotlin

/**
 * Builder for [Inventory].
 */
@PulumiTagMarker
public class InventoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InventoryArgs = InventoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InventoryArgsBuilder.() -> Unit) {
        val builder = InventoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Inventory {
        val builtJavaResource = com.pulumi.aws.s3.Inventory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Inventory(builtJavaResource)
    }
}

/**
 * Provides a S3 bucket [inventory configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add inventory configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucketV2 = new BucketV2("testBucketV2");
 *         var inventory = new BucketV2("inventory");
 *         var testInventory = new Inventory("testInventory", InventoryArgs.builder()
 *             .bucket(testBucketV2.id())
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add inventory configuration with S3 object prefix
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryFilterArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new BucketV2("test");
 *         var inventory = new BucketV2("inventory");
 *         var test_prefix = new Inventory("test-prefix", InventoryArgs.builder()
 *             .bucket(test.id())
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .filter(InventoryFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .prefix("inventory")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket inventory configurations using `bucket:inventory`. For example:
 * ```sh
 *  $ pulumi import aws:s3/inventory:Inventory my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 *
 */
public class Inventory internal constructor(
    override val javaResource: com.pulumi.aws.s3.Inventory,
) : KotlinCustomResource(javaResource, InventoryMapper) {
    /**
     * Name of the source bucket that inventory lists the objects for.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Contains information about where to publish the inventory results (documented below).
     */
    public val destination: Output<InventoryDestination>
        get() = javaResource.destination().applyValue({ args0 ->
            args0.let({ args0 ->
                inventoryDestinationToKotlin(args0)
            })
        })

    /**
     * Specifies whether the inventory is enabled or disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
     */
    public val filter: Output<InventoryFilter>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    inventoryFilterToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Object versions to include in the inventory list. Valid values: `All`, `Current`.
     */
    public val includedObjectVersions: Output<String>
        get() = javaResource.includedObjectVersions().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the inventory configuration for the bucket.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    public val optionalFields: Output<List<String>>?
        get() = javaResource.optionalFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies the schedule for generating inventory results (documented below).
     */
    public val schedule: Output<InventorySchedule>
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.let({ args0 ->
                inventoryScheduleToKotlin(args0)
            })
        })
}

public object InventoryMapper : ResourceMapper<Inventory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3.Inventory::class == javaResource::class

    override fun map(javaResource: Resource): Inventory = Inventory(
        javaResource as
            com.pulumi.aws.s3.Inventory,
    )
}

/**
 * @see [Inventory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Inventory].
 */
public suspend fun inventory(name: String, block: suspend InventoryResourceBuilder.() -> Unit):
    Inventory {
    val builder = InventoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Inventory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inventory(name: String): Inventory {
    val builder = InventoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
