@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.InventoryArgs.builder
import com.pulumi.aws.s3.kotlin.inputs.InventoryDestinationArgs
import com.pulumi.aws.s3.kotlin.inputs.InventoryDestinationArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.InventoryFilterArgs
import com.pulumi.aws.s3.kotlin.inputs.InventoryFilterArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.InventoryScheduleArgs
import com.pulumi.aws.s3.kotlin.inputs.InventoryScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a S3 bucket [inventory configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html) resource.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Add inventory configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBucketV2 = new BucketV2("testBucketV2");
 *         var inventory = new BucketV2("inventory");
 *         var testInventory = new Inventory("testInventory", InventoryArgs.builder()
 *             .bucket(testBucketV2.id())
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Add inventory configuration with S3 object prefix
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.Inventory;
 * import com.pulumi.aws.s3.InventoryArgs;
 * import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
 * import com.pulumi.aws.s3.inputs.InventoryFilterArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
 * import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new BucketV2("test");
 *         var inventory = new BucketV2("inventory");
 *         var test_prefix = new Inventory("test-prefix", InventoryArgs.builder()
 *             .bucket(test.id())
 *             .includedObjectVersions("All")
 *             .schedule(InventoryScheduleArgs.builder()
 *                 .frequency("Daily")
 *                 .build())
 *             .filter(InventoryFilterArgs.builder()
 *                 .prefix("documents/")
 *                 .build())
 *             .destination(InventoryDestinationArgs.builder()
 *                 .bucket(InventoryDestinationBucketArgs.builder()
 *                     .format("ORC")
 *                     .bucketArn(inventory.arn())
 *                     .prefix("inventory")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 bucket inventory configurations using `bucket:inventory`. For example:
 * ```sh
 *  $ pulumi import aws:s3/inventory:Inventory my-bucket-entire-bucket my-bucket:EntireBucket
 * ```
 * @property bucket Name of the source bucket that inventory lists the objects for.
 * @property destination Contains information about where to publish the inventory results (documented below).
 * @property enabled Specifies whether the inventory is enabled or disabled.
 * @property filter Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
 * @property includedObjectVersions Object versions to include in the inventory list. Valid values: `All`, `Current`.
 * @property name Unique identifier of the inventory configuration for the bucket.
 * @property optionalFields List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
 * @property schedule Specifies the schedule for generating inventory results (documented below).
 */
public data class InventoryArgs(
    public val bucket: Output<String>? = null,
    public val destination: Output<InventoryDestinationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val filter: Output<InventoryFilterArgs>? = null,
    public val includedObjectVersions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val optionalFields: Output<List<String>>? = null,
    public val schedule: Output<InventoryScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.InventoryArgs> {
    override fun toJava(): com.pulumi.aws.s3.InventoryArgs = com.pulumi.aws.s3.InventoryArgs.builder()
        .bucket(bucket?.applyValue({ args0 -> args0 }))
        .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .enabled(enabled?.applyValue({ args0 -> args0 }))
        .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .includedObjectVersions(includedObjectVersions?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .optionalFields(optionalFields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InventoryArgs].
 */
@PulumiTagMarker
public class InventoryArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var destination: Output<InventoryDestinationArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var filter: Output<InventoryFilterArgs>? = null

    private var includedObjectVersions: Output<String>? = null

    private var name: Output<String>? = null

    private var optionalFields: Output<List<String>>? = null

    private var schedule: Output<InventoryScheduleArgs>? = null

    /**
     * @param value Name of the source bucket that inventory lists the objects for.
     */
    @JvmName("qncgkavfaokfuaqn")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Contains information about where to publish the inventory results (documented below).
     */
    @JvmName("yeuemyfarnqektmb")
    public suspend fun destination(`value`: Output<InventoryDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Specifies whether the inventory is enabled or disabled.
     */
    @JvmName("mvrvjrapqfsjcgao")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("fbkhijabfkrxkpyo")
    public suspend fun filter(`value`: Output<InventoryFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Object versions to include in the inventory list. Valid values: `All`, `Current`.
     */
    @JvmName("pahaabmsgjhybwjd")
    public suspend fun includedObjectVersions(`value`: Output<String>) {
        this.includedObjectVersions = value
    }

    /**
     * @param value Unique identifier of the inventory configuration for the bucket.
     */
    @JvmName("vddlmhpmxggcpvkp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    @JvmName("rgllsatwssbqpmmv")
    public suspend fun optionalFields(`value`: Output<List<String>>) {
        this.optionalFields = value
    }

    @JvmName("xidlaqefgjtgevmi")
    public suspend fun optionalFields(vararg values: Output<String>) {
        this.optionalFields = Output.all(values.asList())
    }

    /**
     * @param values List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    @JvmName("hayvxdwydrfsablo")
    public suspend fun optionalFields(values: List<Output<String>>) {
        this.optionalFields = Output.all(values)
    }

    /**
     * @param value Specifies the schedule for generating inventory results (documented below).
     */
    @JvmName("mjfpsixwqutxonvb")
    public suspend fun schedule(`value`: Output<InventoryScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Name of the source bucket that inventory lists the objects for.
     */
    @JvmName("cyulywurdnkfqanw")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Contains information about where to publish the inventory results (documented below).
     */
    @JvmName("jxcbrgienketvapp")
    public suspend fun destination(`value`: InventoryDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Contains information about where to publish the inventory results (documented below).
     */
    @JvmName("kkrlogpvabdshfof")
    public suspend fun destination(argument: suspend InventoryDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Specifies whether the inventory is enabled or disabled.
     */
    @JvmName("alhvrjitqpwwpmht")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("rgdbkfhofkbtqwyl")
    public suspend fun filter(`value`: InventoryFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
     */
    @JvmName("jwyyfcpskyrhonrm")
    public suspend fun filter(argument: suspend InventoryFilterArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Object versions to include in the inventory list. Valid values: `All`, `Current`.
     */
    @JvmName("cdussccdxygiiurg")
    public suspend fun includedObjectVersions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedObjectVersions = mapped
    }

    /**
     * @param value Unique identifier of the inventory configuration for the bucket.
     */
    @JvmName("odfphlemgcmmmgeu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    @JvmName("hrciovnusgmisokn")
    public suspend fun optionalFields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionalFields = mapped
    }

    /**
     * @param values List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     */
    @JvmName("cxollohjauimmlwd")
    public suspend fun optionalFields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optionalFields = mapped
    }

    /**
     * @param value Specifies the schedule for generating inventory results (documented below).
     */
    @JvmName("bgcnbbjrlqugfoty")
    public suspend fun schedule(`value`: InventoryScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Specifies the schedule for generating inventory results (documented below).
     */
    @JvmName("iaoawcijdebxjvxa")
    public suspend fun schedule(argument: suspend InventoryScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): InventoryArgs = InventoryArgs(
        bucket = bucket,
        destination = destination,
        enabled = enabled,
        filter = filter,
        includedObjectVersions = includedObjectVersions,
        name = name,
        optionalFields = optionalFields,
        schedule = schedule,
    )
}
