@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin

import com.pulumi.aws.s3.S3Functions.getAccountPublicAccessBlockPlain
import com.pulumi.aws.s3.S3Functions.getBucketObjectPlain
import com.pulumi.aws.s3.S3Functions.getBucketObjectsPlain
import com.pulumi.aws.s3.S3Functions.getBucketPlain
import com.pulumi.aws.s3.S3Functions.getBucketPolicyPlain
import com.pulumi.aws.s3.S3Functions.getCanonicalUserIdPlain
import com.pulumi.aws.s3.S3Functions.getDirectoryBucketsPlain
import com.pulumi.aws.s3.S3Functions.getObjectPlain
import com.pulumi.aws.s3.S3Functions.getObjectsPlain
import com.pulumi.aws.s3.kotlin.inputs.GetAccountPublicAccessBlockPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetAccountPublicAccessBlockPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectsPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketObjectsPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPolicyPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetBucketPolicyPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetObjectPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetObjectPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.inputs.GetObjectsPlainArgs
import com.pulumi.aws.s3.kotlin.inputs.GetObjectsPlainArgsBuilder
import com.pulumi.aws.s3.kotlin.outputs.GetAccountPublicAccessBlockResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectsResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketPolicyResult
import com.pulumi.aws.s3.kotlin.outputs.GetBucketResult
import com.pulumi.aws.s3.kotlin.outputs.GetCanonicalUserIdResult
import com.pulumi.aws.s3.kotlin.outputs.GetDirectoryBucketsResult
import com.pulumi.aws.s3.kotlin.outputs.GetObjectResult
import com.pulumi.aws.s3.kotlin.outputs.GetObjectsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.s3.kotlin.outputs.GetAccountPublicAccessBlockResult.Companion.toKotlin as getAccountPublicAccessBlockResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectResult.Companion.toKotlin as getBucketObjectResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketObjectsResult.Companion.toKotlin as getBucketObjectsResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketPolicyResult.Companion.toKotlin as getBucketPolicyResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetBucketResult.Companion.toKotlin as getBucketResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetCanonicalUserIdResult.Companion.toKotlin as getCanonicalUserIdResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetDirectoryBucketsResult.Companion.toKotlin as getDirectoryBucketsResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetObjectResult.Companion.toKotlin as getObjectResultToKotlin
import com.pulumi.aws.s3.kotlin.outputs.GetObjectsResult.Companion.toKotlin as getObjectsResultToKotlin

public object S3Functions {
    /**
     * The S3 account public access block data source returns account-level public access block configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getAccountPublicAccessBlock();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAccountPublicAccessBlock.
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend fun getAccountPublicAccessBlock(argument: GetAccountPublicAccessBlockPlainArgs):
        GetAccountPublicAccessBlockResult =
        getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(argument.toJava()).await())

    /**
     * @see [getAccountPublicAccessBlock].
     * @param accountId AWS account ID to configure. Defaults to automatically determined account ID of the AWS provider.
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend fun getAccountPublicAccessBlock(accountId: String? = null):
        GetAccountPublicAccessBlockResult {
        val argument = GetAccountPublicAccessBlockPlainArgs(
            accountId = accountId,
        )
        return getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountPublicAccessBlock].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetAccountPublicAccessBlockPlainArgs].
     * @return A collection of values returned by getAccountPublicAccessBlock.
     */
    public suspend
    fun getAccountPublicAccessBlock(argument: suspend GetAccountPublicAccessBlockPlainArgsBuilder.() -> Unit):
        GetAccountPublicAccessBlockResult {
        val builder = GetAccountPublicAccessBlockPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountPublicAccessBlockResultToKotlin(getAccountPublicAccessBlockPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific S3 bucket.
     * This resource may prove useful when setting up a Route53 record, or an origin for a CloudFront
     * Distribution.
     * ## Example Usage
     * ### Route53 Record
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketArgs;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetZoneArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = S3Functions.getBucket(GetBucketArgs.builder()
     *             .bucket("bucket.test.com")
     *             .build());
     *         final var testZone = Route53Functions.getZone(GetZoneArgs.builder()
     *             .name("test.com.")
     *             .build());
     *         var example = new Record("example", RecordArgs.builder()
     *             .zoneId(testZone.applyValue(getZoneResult -> getZoneResult.id()))
     *             .name("bucket")
     *             .type("A")
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(selected.applyValue(getBucketResult -> getBucketResult.websiteDomain()))
     *                 .zoneId(selected.applyValue(getBucketResult -> getBucketResult.hostedZoneId()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### CloudFront Origin
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketArgs;
     * import com.pulumi.aws.cloudfront.Distribution;
     * import com.pulumi.aws.cloudfront.DistributionArgs;
     * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = S3Functions.getBucket(GetBucketArgs.builder()
     *             .bucket("a-test-bucket")
     *             .build());
     *         var test = new Distribution("test", DistributionArgs.builder()
     *             .origins(DistributionOriginArgs.builder()
     *                 .domainName(selected.applyValue(getBucketResult -> getBucketResult.bucketDomainName()))
     *                 .originId("s3-selected-bucket")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBucket.
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(argument: GetBucketPlainArgs): GetBucketResult =
        getBucketResultToKotlin(getBucketPlain(argument.toJava()).await())

    /**
     * @see [getBucket].
     * @param bucket Name of the bucket
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(bucket: String): GetBucketResult {
        val argument = GetBucketPlainArgs(
            bucket = bucket,
        )
        return getBucketResultToKotlin(getBucketPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucket].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketPlainArgs].
     * @return A collection of values returned by getBucket.
     */
    public suspend fun getBucket(argument: suspend GetBucketPlainArgsBuilder.() -> Unit):
        GetBucketResult {
        val builder = GetBucketPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketResultToKotlin(getBucketPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** The `aws.s3.BucketObject` data source is DEPRECATED and will be removed in a future version! Use `aws.s3.BucketObjectv2` instead, where new features and fixes will be added.
     * The S3 object data source allows access to the metadata and
     * _optionally_ (see below) content of an object stored inside S3 bucket.
     * > **Note:** The content of an object (`body` field) is available only for objects which have a human-readable `Content-Type` (`text/*` and `application/json`). This is to prevent printing unsafe characters and potentially downloading large amount of data which would be thrown away in favour of metadata.
     * ## Example Usage
     * The following example retrieves a text object (which must have a `Content-Type`
     * value starting with `text/`) and uses it as the `user_data` for an EC2 instance:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketObjectArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bootstrapScript = S3Functions.getBucketObject(GetBucketObjectArgs.builder()
     *             .bucket("ourcorp-deploy-config")
     *             .key("ec2-bootstrap-script.sh")
     *             .build());
     *         var example = new Instance("example", InstanceArgs.builder()
     *             .instanceType("t2.micro")
     *             .ami("ami-2757f631")
     *             .userData(bootstrapScript.applyValue(getBucketObjectResult -> getBucketObjectResult.body()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBucketObject.
     * @return A collection of values returned by getBucketObject.
     * */
     */
    public suspend fun getBucketObject(argument: GetBucketObjectPlainArgs): GetBucketObjectResult =
        getBucketObjectResultToKotlin(getBucketObjectPlain(argument.toJava()).await())

    /**
     * @see [getBucketObject].
     * @param bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param key Full path to the object inside the bucket
     * @param range
     * @param tags Map of tags assigned to the object.
     * @param versionId Specific version ID of the object returned (defaults to latest version)
     * @return A collection of values returned by getBucketObject.
     */
    public suspend fun getBucketObject(
        bucket: String,
        key: String,
        range: String? = null,
        tags: Map<String, String>? = null,
        versionId: String? = null,
    ): GetBucketObjectResult {
        val argument = GetBucketObjectPlainArgs(
            bucket = bucket,
            key = key,
            range = range,
            tags = tags,
            versionId = versionId,
        )
        return getBucketObjectResultToKotlin(getBucketObjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketObject].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketObjectPlainArgs].
     * @return A collection of values returned by getBucketObject.
     */
    public suspend fun getBucketObject(argument: suspend GetBucketObjectPlainArgsBuilder.() -> Unit):
        GetBucketObjectResult {
        val builder = GetBucketObjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketObjectResultToKotlin(getBucketObjectPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** The `aws.s3.getBucketObjects` data source is DEPRECATED and will be removed in a future version! Use `aws.s3.getObjects` instead, where new features and fixes will be added.
     * > **NOTE on `max_keys`:** Retrieving very large numbers of keys can adversely affect this provider's performance.
     * The objects data source returns keys (i.e., file names) and other metadata about objects in an S3 bucket.
     * @param argument A collection of arguments for invoking getBucketObjects.
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(argument: GetBucketObjectsPlainArgs): GetBucketObjectsResult =
        getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())

    /**
     * @see [getBucketObjects].
     * @param bucket Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param delimiter Character used to group keys (Default: none)
     * @param encodingType Encodes keys using this method (Default: none; besides none, only "url" can be used)
     * @param fetchOwner Boolean specifying whether to populate the owner list (Default: false)
     * @param maxKeys Maximum object keys to return (Default: 1000)
     * @param prefix Limits results to object keys with this prefix (Default: none)
     * @param startAfter Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(
        bucket: String,
        delimiter: String? = null,
        encodingType: String? = null,
        fetchOwner: Boolean? = null,
        maxKeys: Int? = null,
        prefix: String? = null,
        startAfter: String? = null,
    ): GetBucketObjectsResult {
        val argument = GetBucketObjectsPlainArgs(
            bucket = bucket,
            delimiter = delimiter,
            encodingType = encodingType,
            fetchOwner = fetchOwner,
            maxKeys = maxKeys,
            prefix = prefix,
            startAfter = startAfter,
        )
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketObjects].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketObjectsPlainArgs].
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend
    fun getBucketObjects(argument: suspend GetBucketObjectsPlainArgsBuilder.() -> Unit):
        GetBucketObjectsResult {
        val builder = GetBucketObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * The bucket policy data source returns IAM policy of an S3 bucket.
     * ## Example Usage
     * The following example retrieves IAM policy of a specified S3 bucket.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetBucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getBucketPolicy(GetBucketPolicyArgs.builder()
     *             .bucket("example-bucket-name")
     *             .build());
     *         ctx.export("foo", example.applyValue(getBucketPolicyResult -> getBucketPolicyResult.policy()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBucketPolicy.
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(argument: GetBucketPolicyPlainArgs): GetBucketPolicyResult =
        getBucketPolicyResultToKotlin(getBucketPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBucketPolicy].
     * @param bucket Bucket name.
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(bucket: String): GetBucketPolicyResult {
        val argument = GetBucketPolicyPlainArgs(
            bucket = bucket,
        )
        return getBucketPolicyResultToKotlin(getBucketPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetBucketPolicyPlainArgs].
     * @return A collection of values returned by getBucketPolicy.
     */
    public suspend fun getBucketPolicy(argument: suspend GetBucketPolicyPlainArgsBuilder.() -> Unit):
        GetBucketPolicyResult {
        val builder = GetBucketPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketPolicyResultToKotlin(getBucketPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * The Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html)
     * for the effective account in which this provider is working.
     * > **NOTE:** To use this data source, you must have the `s3:ListAllMyBuckets` permission.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * @param argument The Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html)
     * for the effective account in which this provider is working.
     * > **NOTE:** To use this data source, you must have the `s3:ListAllMyBuckets` permission.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = S3Functions.getCanonicalUserId();
     *         ctx.export("canonicalUserId", current.applyValue(getCanonicalUserIdResult -> getCanonicalUserIdResult.id()));
     *     }
     * }
     * ```
     * @return A collection of values returned by getCanonicalUserId.
     */
    public suspend fun getCanonicalUserId(): GetCanonicalUserIdResult =
        getCanonicalUserIdResultToKotlin(getCanonicalUserIdPlain().await())

    /**
     * Lists Amazon S3 Express directory buckets.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * @param argument Lists Amazon S3 Express directory buckets.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3Functions.getDirectoryBuckets();
     *     }
     * }
     * ```
     * @return A collection of values returned by getDirectoryBuckets.
     */
    public suspend fun getDirectoryBuckets(): GetDirectoryBucketsResult =
        getDirectoryBucketsResultToKotlin(getDirectoryBucketsPlain().await())

    /**
     * The S3 object data source allows access to the metadata and
     * _optionally_ (see below) content of an object stored inside S3 bucket.
     * > **Note:** The content of an object (`body` field) is available only for objects which have a human-readable `Content-Type` (`text/*` and `application/json`). This is to prevent printing unsafe characters and potentially downloading large amount of data which would be thrown away in favour of metadata.
     * ## Example Usage
     * The following example retrieves a text object (which must have a `Content-Type`
     * value starting with `text/`) and uses it as the `user_data` for an EC2 instance:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.S3Functions;
     * import com.pulumi.aws.s3.inputs.GetObjectArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bootstrapScript = S3Functions.getObject(GetObjectArgs.builder()
     *             .bucket("ourcorp-deploy-config")
     *             .key("ec2-bootstrap-script.sh")
     *             .build());
     *         var example = new Instance("example", InstanceArgs.builder()
     *             .instanceType("t2.micro")
     *             .ami("ami-2757f631")
     *             .userData(bootstrapScript.applyValue(getObjectResult -> getObjectResult.body()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getObject.
     * @return A collection of values returned by getObject.
     * */
     */
    public suspend fun getObject(argument: GetObjectPlainArgs): GetObjectResult =
        getObjectResultToKotlin(getObjectPlain(argument.toJava()).await())

    /**
     * @see [getObject].
     * @param bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param checksumMode To retrieve the object's checksum, this argument must be `ENABLED`. If you enable `checksum_mode` and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `ENABLED`
     * @param key Full path to the object inside the bucket
     * @param range
     * @param tags Map of tags assigned to the object.
     * @param versionId Specific version ID of the object returned (defaults to latest version)
     * @return A collection of values returned by getObject.
     */
    public suspend fun getObject(
        bucket: String,
        checksumMode: String? = null,
        key: String,
        range: String? = null,
        tags: Map<String, String>? = null,
        versionId: String? = null,
    ): GetObjectResult {
        val argument = GetObjectPlainArgs(
            bucket = bucket,
            checksumMode = checksumMode,
            key = key,
            range = range,
            tags = tags,
            versionId = versionId,
        )
        return getObjectResultToKotlin(getObjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getObject].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetObjectPlainArgs].
     * @return A collection of values returned by getObject.
     */
    public suspend fun getObject(argument: suspend GetObjectPlainArgsBuilder.() -> Unit):
        GetObjectResult {
        val builder = GetObjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObjectResultToKotlin(getObjectPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE on `max_keys`:** Retrieving very large numbers of keys can adversely affect the provider's performance.
     * The objects data source returns keys (i.e., file names) and other metadata about objects in an S3 bucket.
     * @param argument A collection of arguments for invoking getObjects.
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(argument: GetObjectsPlainArgs): GetObjectsResult =
        getObjectsResultToKotlin(getObjectsPlain(argument.toJava()).await())

    /**
     * @see [getObjects].
     * @param bucket Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     * @param delimiter Character used to group keys (Default: none)
     * @param encodingType Encodes keys using this method (Default: none; besides none, only "url" can be used)
     * @param fetchOwner Boolean specifying whether to populate the owner list (Default: false)
     * @param maxKeys Maximum object keys to return (Default: 1000)
     * @param prefix Limits results to object keys with this prefix (Default: none)
     * @param requestPayer Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If included, the only valid value is `requester`.
     * @param startAfter Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(
        bucket: String,
        delimiter: String? = null,
        encodingType: String? = null,
        fetchOwner: Boolean? = null,
        maxKeys: Int? = null,
        prefix: String? = null,
        requestPayer: String? = null,
        startAfter: String? = null,
    ): GetObjectsResult {
        val argument = GetObjectsPlainArgs(
            bucket = bucket,
            delimiter = delimiter,
            encodingType = encodingType,
            fetchOwner = fetchOwner,
            maxKeys = maxKeys,
            prefix = prefix,
            requestPayer = requestPayer,
            startAfter = startAfter,
        )
        return getObjectsResultToKotlin(getObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getObjects].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3&#46;kotlin&#46;inputs&#46;GetObjectsPlainArgs].
     * @return A collection of values returned by getObjects.
     */
    public suspend fun getObjects(argument: suspend GetObjectsPlainArgsBuilder.() -> Unit):
        GetObjectsResult {
        val builder = GetObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObjectsResultToKotlin(getObjectsPlain(builtArgument.toJava()).await())
    }
}
