@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vpcId This access point will only allow connections from the specified VPC ID.
 */
public data class AccessPointVpcConfigurationArgs(
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs =
        com.pulumi.aws.s3.inputs.AccessPointVpcConfigurationArgs.builder()
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointVpcConfigurationArgs].
 */
@PulumiTagMarker
public class AccessPointVpcConfigurationArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    /**
     * @param value This access point will only allow connections from the specified VPC ID.
     */
    @JvmName("ouuelsraplbdfibs")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value This access point will only allow connections from the specified VPC ID.
     */
    @JvmName("qdlnyfsaqhctgnxr")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): AccessPointVpcConfigurationArgs = AccessPointVpcConfigurationArgs(
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
