@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketAccountId Account ID that owns the destination bucket.
 * @property bucketArn ARN of the destination bucket.
 * @property format Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
 * @property prefix Prefix to append to exported analytics data.
 */
public data class
AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs(
    public val bucketAccountId: Output<String>? = null,
    public val bucketArn: Output<String>,
    public val format: Output<String>? = null,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs =
        com.pulumi.aws.s3.inputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs.builder()
            .bucketAccountId(bucketAccountId?.applyValue({ args0 -> args0 }))
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs].
 */
@PulumiTagMarker
public class
AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgsBuilder
internal constructor() {
    private var bucketAccountId: Output<String>? = null

    private var bucketArn: Output<String>? = null

    private var format: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Account ID that owns the destination bucket.
     */
    @JvmName("sdxhwrcgjkltukms")
    public suspend fun bucketAccountId(`value`: Output<String>) {
        this.bucketAccountId = value
    }

    /**
     * @param value ARN of the destination bucket.
     */
    @JvmName("upmwvoankukfraiu")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
     */
    @JvmName("fadkjxkuvyrjgokp")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Prefix to append to exported analytics data.
     */
    @JvmName("bliqkjaoaldvbkmi")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Account ID that owns the destination bucket.
     */
    @JvmName("ifcodyrrarmnclwu")
    public suspend fun bucketAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketAccountId = mapped
    }

    /**
     * @param value ARN of the destination bucket.
     */
    @JvmName("mbwuicbikijowykk")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
     */
    @JvmName("wqftwtbkruelxdgx")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Prefix to append to exported analytics data.
     */
    @JvmName("bppkpiahsllspurk")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build():
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs =
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs(
            bucketAccountId = bucketAccountId,
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            format = format,
            prefix = prefix,
        )
}
