@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grantee Configuration block for the person being granted permissions. See below.
 * @property permission Logging permissions assigned to the grantee for the bucket.
 */
public data class BucketAclV2AccessControlPolicyGrantArgs(
    public val grantee: Output<BucketAclV2AccessControlPolicyGrantGranteeArgs>? = null,
    public val permission: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantArgs =
        com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyGrantArgs.builder()
            .grantee(grantee?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permission(permission.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAclV2AccessControlPolicyGrantArgs].
 */
@PulumiTagMarker
public class BucketAclV2AccessControlPolicyGrantArgsBuilder internal constructor() {
    private var grantee: Output<BucketAclV2AccessControlPolicyGrantGranteeArgs>? = null

    private var permission: Output<String>? = null

    /**
     * @param value Configuration block for the person being granted permissions. See below.
     */
    @JvmName("xdssjaieqvackgnv")
    public suspend fun grantee(`value`: Output<BucketAclV2AccessControlPolicyGrantGranteeArgs>) {
        this.grantee = value
    }

    /**
     * @param value Logging permissions assigned to the grantee for the bucket.
     */
    @JvmName("akdavjbpmojpuous")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Configuration block for the person being granted permissions. See below.
     */
    @JvmName("iydojsduwniwmabj")
    public suspend fun grantee(`value`: BucketAclV2AccessControlPolicyGrantGranteeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantee = mapped
    }

    /**
     * @param argument Configuration block for the person being granted permissions. See below.
     */
    @JvmName("fmbmqtmhxbvigyvs")
    public suspend
    fun grantee(argument: suspend BucketAclV2AccessControlPolicyGrantGranteeArgsBuilder.() -> Unit) {
        val toBeMapped = BucketAclV2AccessControlPolicyGrantGranteeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grantee = mapped
    }

    /**
     * @param value Logging permissions assigned to the grantee for the bucket.
     */
    @JvmName("bqrpjdxstyyhkmhx")
    public suspend fun permission(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    internal fun build(): BucketAclV2AccessControlPolicyGrantArgs =
        BucketAclV2AccessControlPolicyGrantArgs(
            grantee = grantee,
            permission = permission ?: throw PulumiNullFieldException("permission"),
        )
}
