@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHeaders Set of Headers that are specified in the `Access-Control-Request-Headers` header.
 * @property allowedMethods Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
 * @property allowedOrigins Set of origins you want customers to be able to access the bucket from.
 * @property exposeHeaders Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
 * @property id Unique identifier for the rule. The value cannot be longer than 255 characters.
 * @property maxAgeSeconds Time in seconds that your browser is to cache the preflight response for the specified resource.
 */
public data class BucketCorsConfigurationV2CorsRuleArgs(
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>,
    public val allowedOrigins: Output<List<String>>,
    public val exposeHeaders: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val maxAgeSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs =
        com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .maxAgeSeconds(maxAgeSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketCorsConfigurationV2CorsRuleArgs].
 */
@PulumiTagMarker
public class BucketCorsConfigurationV2CorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var maxAgeSeconds: Output<Int>? = null

    /**
     * @param value Set of Headers that are specified in the `Access-Control-Request-Headers` header.
     */
    @JvmName("orecrgdsdltbvjim")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("tpuvmpyxcwpenirp")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of Headers that are specified in the `Access-Control-Request-Headers` header.
     */
    @JvmName("xueejdstmvnnfbxd")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
     */
    @JvmName("lgvdcskycaustemv")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("rgaivkclrpebecdd")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
     */
    @JvmName("bxhebyeuxbkdkrsb")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Set of origins you want customers to be able to access the bucket from.
     */
    @JvmName("hercnalobhnnaoxw")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("fukteqtfnijqfghx")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Set of origins you want customers to be able to access the bucket from.
     */
    @JvmName("leaxmgyssfktfpml")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("rcifxeofukqanexk")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("amaelqqylxgbknfv")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("fenkfipbfivmqmkh")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    @JvmName("bxyxtanlscfuujyo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Time in seconds that your browser is to cache the preflight response for the specified resource.
     */
    @JvmName("orvodiwrscvjfhat")
    public suspend fun maxAgeSeconds(`value`: Output<Int>) {
        this.maxAgeSeconds = value
    }

    /**
     * @param value Set of Headers that are specified in the `Access-Control-Request-Headers` header.
     */
    @JvmName("mdypylcvtqdutrqu")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values Set of Headers that are specified in the `Access-Control-Request-Headers` header.
     */
    @JvmName("qwqowykngbderccg")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
     */
    @JvmName("tobsvluqtjptcrpo")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
     */
    @JvmName("qablevyiwckuxvpw")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Set of origins you want customers to be able to access the bucket from.
     */
    @JvmName("sadvrqseyagdkljg")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Set of origins you want customers to be able to access the bucket from.
     */
    @JvmName("iosewumcapgjnihq")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("hkvtqgssuwkfnmvh")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("vqfpoojcajkvqdov")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    @JvmName("xmdujphmblyfmjxk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Time in seconds that your browser is to cache the preflight response for the specified resource.
     */
    @JvmName("abdhxfmblcatqccu")
    public suspend fun maxAgeSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeSeconds = mapped
    }

    internal fun build(): BucketCorsConfigurationV2CorsRuleArgs =
        BucketCorsConfigurationV2CorsRuleArgs(
            allowedHeaders = allowedHeaders,
            allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
            allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
            exposeHeaders = exposeHeaders,
            id = id,
            maxAgeSeconds = maxAgeSeconds,
        )
}
