@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketCorsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHeaders Specifies which headers are allowed.
 * @property allowedMethods Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
 * @property allowedOrigins Specifies which origins are allowed.
 * @property exposeHeaders Specifies expose header in the response.
 * @property maxAgeSeconds Specifies time in seconds that browser can cache the response for a preflight request.
 */
public data class BucketCorsRuleArgs(
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>,
    public val allowedOrigins: Output<List<String>>,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAgeSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketCorsRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketCorsRuleArgs =
        com.pulumi.aws.s3.inputs.BucketCorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAgeSeconds(maxAgeSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketCorsRuleArgs].
 */
@PulumiTagMarker
public class BucketCorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAgeSeconds: Output<Int>? = null

    /**
     * @param value Specifies which headers are allowed.
     */
    @JvmName("hxdiisuxvjinhkra")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("fpojmbadytttvqpl")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Specifies which headers are allowed.
     */
    @JvmName("ideggbcxlyyuhufd")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("aedlrjgbmxvfcvhr")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("qldvgghlsxtxjgxa")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("ggnuejhugxnxjdky")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Specifies which origins are allowed.
     */
    @JvmName("vriobvlcwswoeite")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("rxgaidnuskcycmnh")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Specifies which origins are allowed.
     */
    @JvmName("qdmbcpwgpsxuratk")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value Specifies expose header in the response.
     */
    @JvmName("wpiwwpvqofkstmcx")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("ailkacqpawblulam")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values Specifies expose header in the response.
     */
    @JvmName("hnwywrqwmovgdjiw")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value Specifies time in seconds that browser can cache the response for a preflight request.
     */
    @JvmName("nkqqgrxigrxhacdm")
    public suspend fun maxAgeSeconds(`value`: Output<Int>) {
        this.maxAgeSeconds = value
    }

    /**
     * @param value Specifies which headers are allowed.
     */
    @JvmName("gbwpuyrnkigcqudl")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values Specifies which headers are allowed.
     */
    @JvmName("xaqplbampnrfbegh")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("wdaamplhnguochbe")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("hckumqordemljhtq")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Specifies which origins are allowed.
     */
    @JvmName("skayyexxmentyvfq")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Specifies which origins are allowed.
     */
    @JvmName("mxkxgdjxfaukfsur")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value Specifies expose header in the response.
     */
    @JvmName("tqksimpnojaalsnr")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values Specifies expose header in the response.
     */
    @JvmName("jxwppejtkbhbwbva")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value Specifies time in seconds that browser can cache the response for a preflight request.
     */
    @JvmName("abkjcvtwmasfltps")
    public suspend fun maxAgeSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeSeconds = mapped
    }

    internal fun build(): BucketCorsRuleArgs = BucketCorsRuleArgs(
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposeHeaders = exposeHeaders,
        maxAgeSeconds = maxAgeSeconds,
    )
}
