@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
 * @property permissions List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
 * @property type Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
 * @property uri Uri address to grant for. Used only when `type` is `Group`.
 */
public data class BucketGrantArgs(
    public val id: Output<String>? = null,
    public val permissions: Output<List<String>>,
    public val type: Output<String>,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketGrantArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketGrantArgs =
        com.pulumi.aws.s3.inputs.BucketGrantArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .permissions(permissions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketGrantArgs].
 */
@PulumiTagMarker
public class BucketGrantArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var permissions: Output<List<String>>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
     */
    @JvmName("toicyewpqqpbnixo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("wrlqpmsclaaqnckw")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("vnkchavqjvncwkwy")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("uxujouowmjdeeswq")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
     */
    @JvmName("ciwamflguowqinvl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Uri address to grant for. Used only when `type` is `Group`.
     */
    @JvmName("tpeuwgbttjyyjnlr")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
     */
    @JvmName("kbltxmayrhspelxr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("dyqpvvenanvbivrk")
    public suspend fun permissions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("brpmitooomchywnb")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
     */
    @JvmName("fedfmrgdcsbrwgui")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Uri address to grant for. Used only when `type` is `Group`.
     */
    @JvmName("ceipalvgbjdvleya")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): BucketGrantArgs = BucketGrantArgs(
        id = id,
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        type = type ?: throw PulumiNullFieldException("type"),
        uri = uri,
    )
}
