@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object key name prefix that identifies the subset of objects to which the configuration applies.
 * @property tags All of these tags must exist in the object's tag set in order for the configuration to apply.
 */
public data class BucketIntelligentTieringConfigurationFilterArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs =
        com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationFilterArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BucketIntelligentTieringConfigurationFilterArgs].
 */
@PulumiTagMarker
public class BucketIntelligentTieringConfigurationFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object key name prefix that identifies the subset of objects to which the configuration applies.
     */
    @JvmName("ctemxnosycxkvbvx")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value All of these tags must exist in the object's tag set in order for the configuration to apply.
     */
    @JvmName("wrgkobglhhmhllqx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object key name prefix that identifies the subset of objects to which the configuration applies.
     */
    @JvmName("sevmbmllaeviwnwk")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value All of these tags must exist in the object's tag set in order for the configuration to apply.
     */
    @JvmName("htiryshjbjrwljbf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values All of these tags must exist in the object's tag set in order for the configuration to apply.
     */
    @JvmName("dabmbxnbcgfmxxpk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketIntelligentTieringConfigurationFilterArgs =
        BucketIntelligentTieringConfigurationFilterArgs(
            prefix = prefix,
            tags = tags,
        )
}
