@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessTier S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
 * @property days Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
 */
public data class BucketIntelligentTieringConfigurationTieringArgs(
    public val accessTier: Output<String>,
    public val days: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs =
        com.pulumi.aws.s3.inputs.BucketIntelligentTieringConfigurationTieringArgs.builder()
            .accessTier(accessTier.applyValue({ args0 -> args0 }))
            .days(days.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketIntelligentTieringConfigurationTieringArgs].
 */
@PulumiTagMarker
public class BucketIntelligentTieringConfigurationTieringArgsBuilder internal constructor() {
    private var accessTier: Output<String>? = null

    private var days: Output<Int>? = null

    /**
     * @param value S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
     */
    @JvmName("bmyntapfdcsxavqw")
    public suspend fun accessTier(`value`: Output<String>) {
        this.accessTier = value
    }

    /**
     * @param value Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
     */
    @JvmName("tbrsnabflwsscdsw")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
     */
    @JvmName("otgbmcoylokdnkta")
    public suspend fun accessTier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
     */
    @JvmName("cqeqhefkeoeykswx")
    public suspend fun days(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    internal fun build(): BucketIntelligentTieringConfigurationTieringArgs =
        BucketIntelligentTieringConfigurationTieringArgs(
            accessTier = accessTier ?: throw PulumiNullFieldException("accessTier"),
            days = days ?: throw PulumiNullFieldException("days"),
        )
}
