@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property daysAfterInitiation Number of days after which Amazon S3 aborts an incomplete multipart upload.
 */
public data class BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs(
    public val daysAfterInitiation: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs.builder()
            .daysAfterInitiation(daysAfterInitiation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgsBuilder internal
constructor() {
    private var daysAfterInitiation: Output<Int>? = null

    /**
     * @param value Number of days after which Amazon S3 aborts an incomplete multipart upload.
     */
    @JvmName("cojhmngcbobrualn")
    public suspend fun daysAfterInitiation(`value`: Output<Int>) {
        this.daysAfterInitiation = value
    }

    /**
     * @param value Number of days after which Amazon S3 aborts an incomplete multipart upload.
     */
    @JvmName("etsjfwbphrktwaug")
    public suspend fun daysAfterInitiation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysAfterInitiation = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs =
        BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs(
            daysAfterInitiation = daysAfterInitiation,
        )
}
