@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property newerNoncurrentVersions Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
 * @property noncurrentDays Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
 */
public data class BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs(
    public val newerNoncurrentVersions: Output<String>? = null,
    public val noncurrentDays: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs.builder()
            .newerNoncurrentVersions(newerNoncurrentVersions?.applyValue({ args0 -> args0 }))
            .noncurrentDays(noncurrentDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgsBuilder internal
constructor() {
    private var newerNoncurrentVersions: Output<String>? = null

    private var noncurrentDays: Output<Int>? = null

    /**
     * @param value Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
     */
    @JvmName("mqooflvrwlwiqafk")
    public suspend fun newerNoncurrentVersions(`value`: Output<String>) {
        this.newerNoncurrentVersions = value
    }

    /**
     * @param value Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
     */
    @JvmName("jnjxuivxrditonhs")
    public suspend fun noncurrentDays(`value`: Output<Int>) {
        this.noncurrentDays = value
    }

    /**
     * @param value Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
     */
    @JvmName("ccxaljkyiwebntgq")
    public suspend fun newerNoncurrentVersions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newerNoncurrentVersions = mapped
    }

    /**
     * @param value Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
     */
    @JvmName("qykuxttvitnnlert")
    public suspend fun noncurrentDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentDays = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs =
        BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs(
            newerNoncurrentVersions = newerNoncurrentVersions,
            noncurrentDays = noncurrentDays,
        )
}
