@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property newerNoncurrentVersions Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
 * @property noncurrentDays Number of days an object is noncurrent before Amazon S3 can perform the associated action.
 * @property storageClass Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
 */
public data class BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs(
    public val newerNoncurrentVersions: Output<String>? = null,
    public val noncurrentDays: Output<Int>? = null,
    public val storageClass: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs.builder()
            .newerNoncurrentVersions(newerNoncurrentVersions?.applyValue({ args0 -> args0 }))
            .noncurrentDays(noncurrentDays?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgsBuilder internal
constructor() {
    private var newerNoncurrentVersions: Output<String>? = null

    private var noncurrentDays: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
     */
    @JvmName("pevshjarjnygtwyk")
    public suspend fun newerNoncurrentVersions(`value`: Output<String>) {
        this.newerNoncurrentVersions = value
    }

    /**
     * @param value Number of days an object is noncurrent before Amazon S3 can perform the associated action.
     */
    @JvmName("ftsbebdsfypgsdkf")
    public suspend fun noncurrentDays(`value`: Output<Int>) {
        this.noncurrentDays = value
    }

    /**
     * @param value Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
     */
    @JvmName("mggegxxvlsbneekl")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
     */
    @JvmName("cavsvqjuwiahrkky")
    public suspend fun newerNoncurrentVersions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newerNoncurrentVersions = mapped
    }

    /**
     * @param value Number of days an object is noncurrent before Amazon S3 can perform the associated action.
     */
    @JvmName("eesoeumiaalswffq")
    public suspend fun noncurrentDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentDays = mapped
    }

    /**
     * @param value Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
     */
    @JvmName("thcnnbjwushuvvxp")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs =
        BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs(
            newerNoncurrentVersions = newerNoncurrentVersions,
            noncurrentDays = noncurrentDays,
            storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
        )
}
