@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property abortIncompleteMultipartUploadDays Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
 * @property enabled Specifies lifecycle rule status.
 * @property expiration Specifies a period in the object's expire (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property noncurrentVersionExpiration Specifies when noncurrent object versions expire (documented below).
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions (documented below).
 * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
 * @property prefix Object key prefix identifying one or more objects to which the rule applies.
 * @property tags Specifies object tags key and value.
 * @property transitions Specifies a period in the object's transitions (documented below).
 */
public data class BucketLifecycleRuleArgs(
    public val abortIncompleteMultipartUploadDays: Output<Int>? = null,
    public val enabled: Output<Boolean>,
    public val expiration: Output<BucketLifecycleRuleExpirationArgs>? = null,
    public val id: Output<String>? = null,
    public val noncurrentVersionExpiration:
    Output<BucketLifecycleRuleNoncurrentVersionExpirationArgs>? = null,
    public val noncurrentVersionTransitions:
    Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>? = null,
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitions: Output<List<BucketLifecycleRuleTransitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleRuleArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleRuleArgs.builder()
            .abortIncompleteMultipartUploadDays(
                abortIncompleteMultipartUploadDays?.applyValue({ args0 ->
                    args0
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .expiration(expiration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .noncurrentVersionExpiration(
                noncurrentVersionExpiration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .noncurrentVersionTransitions(
                noncurrentVersionTransitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitions(
                transitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketLifecycleRuleArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleArgsBuilder internal constructor() {
    private var abortIncompleteMultipartUploadDays: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var expiration: Output<BucketLifecycleRuleExpirationArgs>? = null

    private var id: Output<String>? = null

    private var noncurrentVersionExpiration:
        Output<BucketLifecycleRuleNoncurrentVersionExpirationArgs>? = null

    private var noncurrentVersionTransitions:
        Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>? = null

    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitions: Output<List<BucketLifecycleRuleTransitionArgs>>? = null

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
     */
    @JvmName("gaxcmgiqojmmfysf")
    public suspend fun abortIncompleteMultipartUploadDays(`value`: Output<Int>) {
        this.abortIncompleteMultipartUploadDays = value
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("vtgkhlnpymwgupop")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies a period in the object's expire (documented below).
     */
    @JvmName("uhivenhqidtpqwon")
    public suspend fun expiration(`value`: Output<BucketLifecycleRuleExpirationArgs>) {
        this.expiration = value
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("hpvuakiiteulahoc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies when noncurrent object versions expire (documented below).
     */
    @JvmName("cuaqhykdtbrhihym")
    public suspend
    fun noncurrentVersionExpiration(`value`: Output<BucketLifecycleRuleNoncurrentVersionExpirationArgs>) {
        this.noncurrentVersionExpiration = value
    }

    /**
     * @param value Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("sriffpuiesyqiyuh")
    public suspend
    fun noncurrentVersionTransitions(`value`: Output<List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = value
    }

    @JvmName("axqirljrsbjomwna")
    public suspend fun noncurrentVersionTransitions(
        vararg
        values: Output<BucketLifecycleRuleNoncurrentVersionTransitionArgs>,
    ) {
        this.noncurrentVersionTransitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("hqsimqfpniyqynja")
    public suspend
    fun noncurrentVersionTransitions(values: List<Output<BucketLifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = Output.all(values)
    }

    /**
     * @param value Object key prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("sqfgtirmlaodqksw")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Specifies object tags key and value.
     */
    @JvmName("nmiaadyilfxdvvsq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies a period in the object's transitions (documented below).
     */
    @JvmName("osvkqgmusbbqkvat")
    public suspend fun transitions(`value`: Output<List<BucketLifecycleRuleTransitionArgs>>) {
        this.transitions = value
    }

    @JvmName("luvkbvlahalpshjw")
    public suspend fun transitions(vararg values: Output<BucketLifecycleRuleTransitionArgs>) {
        this.transitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies a period in the object's transitions (documented below).
     */
    @JvmName("mnagapsurubscnvl")
    public suspend fun transitions(values: List<Output<BucketLifecycleRuleTransitionArgs>>) {
        this.transitions = Output.all(values)
    }

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
     */
    @JvmName("pfhqekyloklbtqdc")
    public suspend fun abortIncompleteMultipartUploadDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortIncompleteMultipartUploadDays = mapped
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("jxshgpkxleyhpmtm")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies a period in the object's expire (documented below).
     */
    @JvmName("xgrulplkbacpqtmf")
    public suspend fun expiration(`value`: BucketLifecycleRuleExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire (documented below).
     */
    @JvmName("bdfwasxlatkewqsx")
    public suspend
    fun expiration(argument: suspend BucketLifecycleRuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleRuleExpirationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expiration = mapped
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("dpjmxyoyotvimilj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions expire (documented below).
     */
    @JvmName("shdqkooatdekcmol")
    public suspend
    fun noncurrentVersionExpiration(`value`: BucketLifecycleRuleNoncurrentVersionExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionExpiration = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire (documented below).
     */
    @JvmName("tfutblxkgcvvpbwt")
    public suspend
    fun noncurrentVersionExpiration(argument: suspend BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpiration = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("yyvfpmigcfbnwyvl")
    public suspend
    fun noncurrentVersionTransitions(`value`: List<BucketLifecycleRuleNoncurrentVersionTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("uarqklhiuopbripp")
    public suspend
    fun noncurrentVersionTransitions(argument: List<suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("wdqbvisjqftcydnu")
    public suspend fun noncurrentVersionTransitions(
        vararg
        argument: suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("twgmdojmkgsvmbkg")
    public suspend
    fun noncurrentVersionTransitions(argument: suspend BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param values Specifies when noncurrent object versions transitions (documented below).
     * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
     */
    @JvmName("dncttorcdleyedmv")
    public suspend fun noncurrentVersionTransitions(
        vararg
        values: BucketLifecycleRuleNoncurrentVersionTransitionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param value Object key prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("iahvxaittktuvvmg")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Specifies object tags key and value.
     */
    @JvmName("mugpqqokjphkdatc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Specifies object tags key and value.
     */
    @JvmName("bopousdbygakiijq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies a period in the object's transitions (documented below).
     */
    @JvmName("knqifylampiwwlmq")
    public suspend fun transitions(`value`: List<BucketLifecycleRuleTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions (documented below).
     */
    @JvmName("wkttulqrayhxjarx")
    public suspend
    fun transitions(argument: List<suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions (documented below).
     */
    @JvmName("knukmlyukmkjerxk")
    public suspend fun transitions(
        vararg
        argument: suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions (documented below).
     */
    @JvmName("moghmdoasipbjjfd")
    public suspend
    fun transitions(argument: suspend BucketLifecycleRuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleRuleTransitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param values Specifies a period in the object's transitions (documented below).
     */
    @JvmName("ljyuteikhntebibg")
    public suspend fun transitions(vararg values: BucketLifecycleRuleTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    internal fun build(): BucketLifecycleRuleArgs = BucketLifecycleRuleArgs(
        abortIncompleteMultipartUploadDays = abortIncompleteMultipartUploadDays,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        expiration = expiration,
        id = id,
        noncurrentVersionExpiration = noncurrentVersionExpiration,
        noncurrentVersionTransitions = noncurrentVersionTransitions,
        prefix = prefix,
        tags = tags,
        transitions = transitions,
    )
}
