@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLifecycleRuleTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property date Specifies the date after which you want the corresponding action to take effect.
 * @property days Specifies the number of days after object creation when the specific rule action takes effect.
 * @property storageClass Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
 */
public data class BucketLifecycleRuleTransitionArgs(
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val storageClass: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLifecycleRuleTransitionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLifecycleRuleTransitionArgs =
        com.pulumi.aws.s3.inputs.BucketLifecycleRuleTransitionArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleRuleTransitionArgs].
 */
@PulumiTagMarker
public class BucketLifecycleRuleTransitionArgsBuilder internal constructor() {
    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect.
     */
    @JvmName("twqrufrtstvsalfp")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Specifies the number of days after object creation when the specific rule action takes effect.
     */
    @JvmName("fqngvgnmoioqavbs")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("qejrcxtviialooka")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect.
     */
    @JvmName("revtqslvajsjdiqo")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Specifies the number of days after object creation when the specific rule action takes effect.
     */
    @JvmName("rnflcgrkmfodurxm")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("qkepklrxefcdyyth")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketLifecycleRuleTransitionArgs = BucketLifecycleRuleTransitionArgs(
        date = date,
        days = days,
        storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
    )
}
