@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grantee Configuration block for the person being granted permissions. See below.
 * @property permission Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
 */
public data class BucketLoggingV2TargetGrantArgs(
    public val grantee: Output<BucketLoggingV2TargetGrantGranteeArgs>,
    public val permission: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs =
        com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs.builder()
            .grantee(grantee.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permission(permission.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingV2TargetGrantArgs].
 */
@PulumiTagMarker
public class BucketLoggingV2TargetGrantArgsBuilder internal constructor() {
    private var grantee: Output<BucketLoggingV2TargetGrantGranteeArgs>? = null

    private var permission: Output<String>? = null

    /**
     * @param value Configuration block for the person being granted permissions. See below.
     */
    @JvmName("egxpwcqswscnctgo")
    public suspend fun grantee(`value`: Output<BucketLoggingV2TargetGrantGranteeArgs>) {
        this.grantee = value
    }

    /**
     * @param value Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
     */
    @JvmName("potnmmwqjkktoaae")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Configuration block for the person being granted permissions. See below.
     */
    @JvmName("skivfrvhhihkrrsi")
    public suspend fun grantee(`value`: BucketLoggingV2TargetGrantGranteeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grantee = mapped
    }

    /**
     * @param argument Configuration block for the person being granted permissions. See below.
     */
    @JvmName("pkyvjwtbgxvifint")
    public suspend
    fun grantee(argument: suspend BucketLoggingV2TargetGrantGranteeArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLoggingV2TargetGrantGranteeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grantee = mapped
    }

    /**
     * @param value Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
     */
    @JvmName("exnmhefjsgmbnpab")
    public suspend fun permission(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    internal fun build(): BucketLoggingV2TargetGrantArgs = BucketLoggingV2TargetGrantArgs(
        grantee = grantee ?: throw PulumiNullFieldException("grantee"),
        permission = permission ?: throw PulumiNullFieldException("permission"),
    )
}
