@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantGranteeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property displayName
 * @property emailAddress Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
 * @property id Canonical user ID of the grantee.
 * @property type Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
 * @property uri URI of the grantee group.
 */
public data class BucketLoggingV2TargetGrantGranteeArgs(
    public val displayName: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val id: Output<String>? = null,
    public val type: Output<String>,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantGranteeArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantGranteeArgs =
        com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantGranteeArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingV2TargetGrantGranteeArgs].
 */
@PulumiTagMarker
public class BucketLoggingV2TargetGrantGranteeArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var id: Output<String>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("favvwevkbdomtvqp")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
     */
    @JvmName("wpsyerrfsxwjumsp")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value Canonical user ID of the grantee.
     */
    @JvmName("hhurayriclnjpwbf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
     */
    @JvmName("cweoronxrubireph")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value URI of the grantee group.
     */
    @JvmName("fqjwimoekbybsalq")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value
     */
    @JvmName("tiisrlvqprqcsgrw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
     */
    @JvmName("ajoeytsbxjrnditr")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value Canonical user ID of the grantee.
     */
    @JvmName("gpjrmlxeqwlrpjhy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
     */
    @JvmName("htwttitjeunpallo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value URI of the grantee group.
     */
    @JvmName("iwmdbwxmbyxpiphm")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): BucketLoggingV2TargetGrantGranteeArgs =
        BucketLoggingV2TargetGrantGranteeArgs(
            displayName = displayName,
            emailAddress = emailAddress,
            id = id,
            type = type ?: throw PulumiNullFieldException("type"),
            uri = uri,
        )
}
