@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionDateSource Specifies the partition date source for the partitioned prefix. Valid values: `EventTime`, `DeliveryTime`.
 */
public data class BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs(
    public val partitionDateSource: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs =
        com.pulumi.aws.s3.inputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs.builder()
            .partitionDateSource(partitionDateSource.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs].
 */
@PulumiTagMarker
public class BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgsBuilder internal constructor() {
    private var partitionDateSource: Output<String>? = null

    /**
     * @param value Specifies the partition date source for the partitioned prefix. Valid values: `EventTime`, `DeliveryTime`.
     */
    @JvmName("olgdkjrybhvkjsat")
    public suspend fun partitionDateSource(`value`: Output<String>) {
        this.partitionDateSource = value
    }

    /**
     * @param value Specifies the partition date source for the partitioned prefix. Valid values: `EventTime`, `DeliveryTime`.
     */
    @JvmName("wgyorfxkootxtyis")
    public suspend fun partitionDateSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionDateSource = mapped
    }

    internal fun build(): BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs =
        BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs(
            partitionDateSource = partitionDateSource ?: throw PulumiNullFieldException("partitionDateSource"),
        )
}
