@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketMetricFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object prefix for filtering (singular).
 * @property tags Object tags for filtering (up to 10).
 */
public data class BucketMetricFilterArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketMetricFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketMetricFilterArgs =
        com.pulumi.aws.s3.inputs.BucketMetricFilterArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BucketMetricFilterArgs].
 */
@PulumiTagMarker
public class BucketMetricFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object prefix for filtering (singular).
     */
    @JvmName("aarcskwsvdwubddr")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Object tags for filtering (up to 10).
     */
    @JvmName("lamysatiwmeafxpi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object prefix for filtering (singular).
     */
    @JvmName("hygkcqefljgdvlbm")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Object tags for filtering (up to 10).
     */
    @JvmName("uqiadykvokryehxm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Object tags for filtering (up to 10).
     */
    @JvmName("nntexfixoexhambl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketMetricFilterArgs = BucketMetricFilterArgs(
        prefix = prefix,
        tags = tags,
    )
}
