@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
 * @property filterPrefix Object key name prefix.
 * @property filterSuffix Object key name suffix.
 * @property id Unique identifier for each of the notification configurations.
 * @property topicArn SNS topic ARN.
 */
public data class BucketNotificationTopicArgs(
    public val events: Output<List<String>>,
    public val filterPrefix: Output<String>? = null,
    public val filterSuffix: Output<String>? = null,
    public val id: Output<String>? = null,
    public val topicArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs =
        com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs.builder()
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filterPrefix(filterPrefix?.applyValue({ args0 -> args0 }))
            .filterSuffix(filterSuffix?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketNotificationTopicArgs].
 */
@PulumiTagMarker
public class BucketNotificationTopicArgsBuilder internal constructor() {
    private var events: Output<List<String>>? = null

    private var filterPrefix: Output<String>? = null

    private var filterSuffix: Output<String>? = null

    private var id: Output<String>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("kmoskthkfaydkyax")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("qjxjdjvjnahagprt")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("xogqwmekjcqigdlt")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("yirhpbdiurkbfwsp")
    public suspend fun filterPrefix(`value`: Output<String>) {
        this.filterPrefix = value
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("bkciheguowidlrfj")
    public suspend fun filterSuffix(`value`: Output<String>) {
        this.filterSuffix = value
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("vosievtrcvqtouda")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value SNS topic ARN.
     */
    @JvmName("uxvkykpoutqssvhx")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("ymsfnuqeawqffvlm")
    public suspend fun events(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
     */
    @JvmName("mkpbnlahshapcbjr")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Object key name prefix.
     */
    @JvmName("bbcabfpslhpemdcs")
    public suspend fun filterPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPrefix = mapped
    }

    /**
     * @param value Object key name suffix.
     */
    @JvmName("hyqcmjdpvxxogltv")
    public suspend fun filterSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterSuffix = mapped
    }

    /**
     * @param value Unique identifier for each of the notification configurations.
     */
    @JvmName("vlelhvnobwejfvsc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value SNS topic ARN.
     */
    @JvmName("orrvlabmyquvvkac")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): BucketNotificationTopicArgs = BucketNotificationTopicArgs(
        events = events ?: throw PulumiNullFieldException("events"),
        filterPrefix = filterPrefix,
        filterSuffix = filterSuffix,
        id = id,
        topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
    )
}
