@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
 * @property rule The Object Lock rule in place for this bucket.
 */
public data class BucketObjectLockConfigurationArgs(
    public val objectLockEnabled: Output<String>,
    public val rule: Output<BucketObjectLockConfigurationRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationArgs.builder()
            .objectLockEnabled(objectLockEnabled.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketObjectLockConfigurationArgs].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationArgsBuilder internal constructor() {
    private var objectLockEnabled: Output<String>? = null

    private var rule: Output<BucketObjectLockConfigurationRuleArgs>? = null

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
     */
    @JvmName("vesnpgsndoqfaarl")
    public suspend fun objectLockEnabled(`value`: Output<String>) {
        this.objectLockEnabled = value
    }

    /**
     * @param value The Object Lock rule in place for this bucket.
     */
    @JvmName("acxbndkhnhojyncu")
    public suspend fun rule(`value`: Output<BucketObjectLockConfigurationRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
     */
    @JvmName("qsxoelqpmbxxmwyj")
    public suspend fun objectLockEnabled(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectLockEnabled = mapped
    }

    /**
     * @param value The Object Lock rule in place for this bucket.
     */
    @JvmName("grmntcmfbswuiall")
    public suspend fun rule(`value`: BucketObjectLockConfigurationRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument The Object Lock rule in place for this bucket.
     */
    @JvmName("bcenkxymqoalvcnr")
    public suspend
    fun rule(argument: suspend BucketObjectLockConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    internal fun build(): BucketObjectLockConfigurationArgs = BucketObjectLockConfigurationArgs(
        objectLockEnabled = objectLockEnabled ?: throw PulumiNullFieldException("objectLockEnabled"),
        rule = rule,
    )
}
