@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultRetention Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
 */
public data class BucketObjectLockConfigurationV2RuleArgs(
    public val defaultRetention: Output<BucketObjectLockConfigurationV2RuleDefaultRetentionArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs =
        com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs.builder()
            .defaultRetention(
                defaultRetention.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketObjectLockConfigurationV2RuleArgs].
 */
@PulumiTagMarker
public class BucketObjectLockConfigurationV2RuleArgsBuilder internal constructor() {
    private var defaultRetention: Output<BucketObjectLockConfigurationV2RuleDefaultRetentionArgs>? =
        null

    /**
     * @param value Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
     */
    @JvmName("vxqihpnoqgroqlyu")
    public suspend
    fun defaultRetention(`value`: Output<BucketObjectLockConfigurationV2RuleDefaultRetentionArgs>) {
        this.defaultRetention = value
    }

    /**
     * @param value Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
     */
    @JvmName("gfhpnheuvrbspqob")
    public suspend
    fun defaultRetention(`value`: BucketObjectLockConfigurationV2RuleDefaultRetentionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRetention = mapped
    }

    /**
     * @param argument Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
     */
    @JvmName("vsstpknekygikeqr")
    public suspend
    fun defaultRetention(argument: suspend BucketObjectLockConfigurationV2RuleDefaultRetentionArgsBuilder.() -> Unit) {
        val toBeMapped = BucketObjectLockConfigurationV2RuleDefaultRetentionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultRetention = mapped
    }

    internal fun build(): BucketObjectLockConfigurationV2RuleArgs =
        BucketObjectLockConfigurationV2RuleArgs(
            defaultRetention = defaultRetention ?: throw PulumiNullFieldException("defaultRetention"),
        )
}
