@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property objectOwnership Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
 */
public data class BucketOwnershipControlsRuleArgs(
    public val objectOwnership: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs =
        com.pulumi.aws.s3.inputs.BucketOwnershipControlsRuleArgs.builder()
            .objectOwnership(objectOwnership.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketOwnershipControlsRuleArgs].
 */
@PulumiTagMarker
public class BucketOwnershipControlsRuleArgsBuilder internal constructor() {
    private var objectOwnership: Output<String>? = null

    /**
     * @param value Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
     */
    @JvmName("wrrrludntogpiwex")
    public suspend fun objectOwnership(`value`: Output<String>) {
        this.objectOwnership = value
    }

    /**
     * @param value Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
     */
    @JvmName("yjwgqjdjscjfrqap")
    public suspend fun objectOwnership(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectOwnership = mapped
    }

    internal fun build(): BucketOwnershipControlsRuleArgs = BucketOwnershipControlsRuleArgs(
        objectOwnership = objectOwnership ?: throw PulumiNullFieldException("objectOwnership"),
    )
}
