@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicaKmsKeyId ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
 */
public data class BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs(
    public val replicaKmsKeyId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs.builder()
            .replicaKmsKeyId(replicaKmsKeyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDestinationEncryptionConfigurationArgsBuilder internal
constructor() {
    private var replicaKmsKeyId: Output<String>? = null

    /**
     * @param value ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
     */
    @JvmName("skobjodqmweqjjit")
    public suspend fun replicaKmsKeyId(`value`: Output<String>) {
        this.replicaKmsKeyId = value
    }

    /**
     * @param value ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
     */
    @JvmName("eixcoymcagewkieq")
    public suspend fun replicaKmsKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicaKmsKeyId = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs =
        BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs(
            replicaKmsKeyId = replicaKmsKeyId ?: throw PulumiNullFieldException("replicaKmsKeyId"),
        )
}
