@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property eventThreshold Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
 * @property status Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
 */
public data class BucketReplicationConfigRuleDestinationMetricsArgs(
    public val eventThreshold:
    Output<BucketReplicationConfigRuleDestinationMetricsEventThresholdArgs>? = null,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationMetricsArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationMetricsArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationMetricsArgs.builder()
            .eventThreshold(eventThreshold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDestinationMetricsArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDestinationMetricsArgsBuilder internal constructor() {
    private var eventThreshold:
        Output<BucketReplicationConfigRuleDestinationMetricsEventThresholdArgs>? = null

    private var status: Output<String>? = null

    /**
     * @param value Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
     */
    @JvmName("inprtnkfohdopnkb")
    public suspend
    fun eventThreshold(`value`: Output<BucketReplicationConfigRuleDestinationMetricsEventThresholdArgs>) {
        this.eventThreshold = value
    }

    /**
     * @param value Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("bvmbntdegtkvydlb")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
     */
    @JvmName("xvgudbdkqjvrafkr")
    public suspend
    fun eventThreshold(`value`: BucketReplicationConfigRuleDestinationMetricsEventThresholdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventThreshold = mapped
    }

    /**
     * @param argument Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
     */
    @JvmName("pabybuiwdjwlcduh")
    public suspend
    fun eventThreshold(argument: suspend BucketReplicationConfigRuleDestinationMetricsEventThresholdArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigRuleDestinationMetricsEventThresholdArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.eventThreshold = mapped
    }

    /**
     * @param value Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("coossrpgequpfooo")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDestinationMetricsArgs =
        BucketReplicationConfigRuleDestinationMetricsArgs(
            eventThreshold = eventThreshold,
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
