@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property status Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
 * @property time Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
 */
public data class BucketReplicationConfigRuleDestinationReplicationTimeArgs(
    public val status: Output<String>,
    public val time: Output<BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeArgs.builder()
            .status(status.applyValue({ args0 -> args0 }))
            .time(time.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDestinationReplicationTimeArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDestinationReplicationTimeArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    private var time: Output<BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs>? = null

    /**
     * @param value Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("ongwjeuqdpmcgxhp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
     */
    @JvmName("mkykynmbbckiskis")
    public suspend
    fun time(`value`: Output<BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs>) {
        this.time = value
    }

    /**
     * @param value Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("wbmdllsybxvrxkos")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
     */
    @JvmName("yekffofsyloliavr")
    public suspend fun time(`value`: BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.time = mapped
    }

    /**
     * @param argument Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
     */
    @JvmName("hugtotcnltjybgmy")
    public suspend
    fun time(argument: suspend BucketReplicationConfigRuleDestinationReplicationTimeTimeArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigRuleDestinationReplicationTimeTimeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.time = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDestinationReplicationTimeArgs =
        BucketReplicationConfigRuleDestinationReplicationTimeArgs(
            status = status ?: throw PulumiNullFieldException("status"),
            time = time ?: throw PulumiNullFieldException("time"),
        )
}
