@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minutes Time in minutes. Valid values: `15`.
 */
public data class BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs(
    public val minutes: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs.builder()
            .minutes(minutes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleDestinationReplicationTimeTimeArgsBuilder internal
constructor() {
    private var minutes: Output<Int>? = null

    /**
     * @param value Time in minutes. Valid values: `15`.
     */
    @JvmName("lqjrbaksqjtcdvdh")
    public suspend fun minutes(`value`: Output<Int>) {
        this.minutes = value
    }

    /**
     * @param value Time in minutes. Valid values: `15`.
     */
    @JvmName("klwohmiiarltkvev")
    public suspend fun minutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    internal fun build(): BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs =
        BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs(
            minutes = minutes ?: throw PulumiNullFieldException("minutes"),
        )
}
