@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property tags Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
 */
public data class BucketReplicationConfigRuleFilterAndArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterAndArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterAndArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterAndArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BucketReplicationConfigRuleFilterAndArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleFilterAndArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("gkgjesrtqadtclld")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("pdufdeewkeigdnsf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("mvaxfnbmemtovjfb")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("fhyjufohrfgyvjwc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("lwjlrreyareldypq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketReplicationConfigRuleFilterAndArgs =
        BucketReplicationConfigRuleFilterAndArgs(
            prefix = prefix,
            tags = tags,
        )
}
