@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property and Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
 * @property prefix Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property tag Configuration block for specifying a tag key and value. See below.
 */
public data class BucketReplicationConfigRuleFilterArgs(
    public val and: Output<BucketReplicationConfigRuleFilterAndArgs>? = null,
    public val prefix: Output<String>? = null,
    public val tag: Output<BucketReplicationConfigRuleFilterTagArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs.builder()
            .and(and?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleFilterArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleFilterArgsBuilder internal constructor() {
    private var and: Output<BucketReplicationConfigRuleFilterAndArgs>? = null

    private var prefix: Output<String>? = null

    private var tag: Output<BucketReplicationConfigRuleFilterTagArgs>? = null

    /**
     * @param value Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
     */
    @JvmName("nlhqwwuwdubibprm")
    public suspend fun and(`value`: Output<BucketReplicationConfigRuleFilterAndArgs>) {
        this.and = value
    }

    /**
     * @param value Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("uglacrbskmsghqqc")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("dugwxsqsslohtghq")
    public suspend fun tag(`value`: Output<BucketReplicationConfigRuleFilterTagArgs>) {
        this.tag = value
    }

    /**
     * @param value Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
     */
    @JvmName("rxaxomnxsosmiayh")
    public suspend fun and(`value`: BucketReplicationConfigRuleFilterAndArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param argument Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
     */
    @JvmName("kghravpgiamsfqpy")
    public suspend
    fun and(argument: suspend BucketReplicationConfigRuleFilterAndArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleFilterAndArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param value Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("cymychqgwhahwuyc")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("aknxrmnorhaltgrd")
    public suspend fun tag(`value`: BucketReplicationConfigRuleFilterTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param argument Configuration block for specifying a tag key and value. See below.
     */
    @JvmName("fxsdseootcyosthq")
    public suspend
    fun tag(argument: suspend BucketReplicationConfigRuleFilterTagArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigRuleFilterTagArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tag = mapped
    }

    internal fun build(): BucketReplicationConfigRuleFilterArgs =
        BucketReplicationConfigRuleFilterArgs(
            and = and,
            prefix = prefix,
            tag = tag,
        )
}
