@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Name of the object key.
 * @property value Value of the tag.
 */
public data class BucketReplicationConfigRuleFilterTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterTagArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterTagArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleFilterTagArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleFilterTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the object key.
     */
    @JvmName("tkkllepcaeurbroi")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value of the tag.
     */
    @JvmName("mvebsqgtnsygvijy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the object key.
     */
    @JvmName("rhppfkbpsdgiqskc")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value of the tag.
     */
    @JvmName("shbdtvkexgpedpab")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): BucketReplicationConfigRuleFilterTagArgs =
        BucketReplicationConfigRuleFilterTagArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
