@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property owner The override value for the owner on replicated objects. Currently only `Destination` is supported.
 */
public data class BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs(
    public val owner: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs.builder()
            .owner(owner.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder
internal constructor() {
    private var owner: Output<String>? = null

    /**
     * @param value The override value for the owner on replicated objects. Currently only `Destination` is supported.
     */
    @JvmName("wonbcywesadbnisc")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value The override value for the owner on replicated objects. Currently only `Destination` is supported.
     */
    @JvmName("jwjknifucprrpsrr")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    internal fun build(): BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs =
        BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs(
            owner = owner ?: throw PulumiNullFieldException("owner"),
        )
}
