@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlTranslation Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
 * @property accountId The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
 * @property bucket The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
 * @property metrics Enables replication metrics (required for S3 RTC) (documented below).
 * @property replicaKmsKeyId Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
 * `sse_kms_encrypted_objects` source selection criteria.
 * @property replicationTime Enables S3 Replication Time Control (S3 RTC) (documented below).
 * @property storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
 */
public data class BucketReplicationConfigurationRuleDestinationArgs(
    public val accessControlTranslation:
    Output<BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs>? = null,
    public val accountId: Output<String>? = null,
    public val bucket: Output<String>,
    public val metrics: Output<BucketReplicationConfigurationRuleDestinationMetricsArgs>? = null,
    public val replicaKmsKeyId: Output<String>? = null,
    public val replicationTime:
    Output<BucketReplicationConfigurationRuleDestinationReplicationTimeArgs>? = null,
    public val storageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleDestinationArgs.builder()
            .accessControlTranslation(
                accessControlTranslation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .metrics(metrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicaKmsKeyId(replicaKmsKeyId?.applyValue({ args0 -> args0 }))
            .replicationTime(replicationTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageClass(storageClass?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigurationRuleDestinationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigurationRuleDestinationArgsBuilder internal constructor() {
    private var accessControlTranslation:
        Output<BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs>? = null

    private var accountId: Output<String>? = null

    private var bucket: Output<String>? = null

    private var metrics: Output<BucketReplicationConfigurationRuleDestinationMetricsArgs>? = null

    private var replicaKmsKeyId: Output<String>? = null

    private var replicationTime:
        Output<BucketReplicationConfigurationRuleDestinationReplicationTimeArgs>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("otxncbxmcofifihp")
    public suspend
    fun accessControlTranslation(`value`: Output<BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs>) {
        this.accessControlTranslation = value
    }

    /**
     * @param value The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
     */
    @JvmName("oipcokwbklruqyne")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
     */
    @JvmName("icrhjqseikkoxljn")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("hhcfcwvnmqbroclt")
    public suspend
    fun metrics(`value`: Output<BucketReplicationConfigurationRuleDestinationMetricsArgs>) {
        this.metrics = value
    }

    /**
     * @param value Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
     * `sse_kms_encrypted_objects` source selection criteria.
     */
    @JvmName("egaxchtitnvvhlvm")
    public suspend fun replicaKmsKeyId(`value`: Output<String>) {
        this.replicaKmsKeyId = value
    }

    /**
     * @param value Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("tthooswgdugcnfun")
    public suspend
    fun replicationTime(`value`: Output<BucketReplicationConfigurationRuleDestinationReplicationTimeArgs>) {
        this.replicationTime = value
    }

    /**
     * @param value The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     */
    @JvmName("qtvhvqhamvhtturc")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("skurcyffgtrhvsno")
    public suspend
    fun accessControlTranslation(`value`: BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlTranslation = mapped
    }

    /**
     * @param argument Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("tfpfsxaiuequuvvx")
    public suspend
    fun accessControlTranslation(argument: suspend BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlTranslation = mapped
    }

    /**
     * @param value The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
     */
    @JvmName("lprhfxdgjsulyinw")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
     */
    @JvmName("xlemcxxiutajnmps")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("dgusvphcgvkdfeok")
    public suspend fun metrics(`value`: BucketReplicationConfigurationRuleDestinationMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("penrehvadwthadux")
    public suspend
    fun metrics(argument: suspend BucketReplicationConfigurationRuleDestinationMetricsArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigurationRuleDestinationMetricsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param value Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
     * `sse_kms_encrypted_objects` source selection criteria.
     */
    @JvmName("qosqcmxomfjvdbkx")
    public suspend fun replicaKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaKmsKeyId = mapped
    }

    /**
     * @param value Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("wqexsnowwbwvlsmt")
    public suspend
    fun replicationTime(`value`: BucketReplicationConfigurationRuleDestinationReplicationTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationTime = mapped
    }

    /**
     * @param argument Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("pojmrsmmgwjodmqh")
    public suspend
    fun replicationTime(argument: suspend BucketReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.replicationTime = mapped
    }

    /**
     * @param value The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     */
    @JvmName("yciesogaivyqcpwb")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketReplicationConfigurationRuleDestinationArgs =
        BucketReplicationConfigurationRuleDestinationArgs(
            accessControlTranslation = accessControlTranslation,
            accountId = accountId,
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            metrics = metrics,
            replicaKmsKeyId = replicaKmsKeyId,
            replicationTime = replicationTime,
            storageClass = storageClass,
        )
}
