@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property rule A single object for server-side encryption by default configuration. (documented below)
 */
public data class BucketServerSideEncryptionConfigurationArgs(
    public val rule: Output<BucketServerSideEncryptionConfigurationRuleArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationArgs.builder()
            .rule(rule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketServerSideEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class BucketServerSideEncryptionConfigurationArgsBuilder internal constructor() {
    private var rule: Output<BucketServerSideEncryptionConfigurationRuleArgs>? = null

    /**
     * @param value A single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("ouoxnurmyomlkluj")
    public suspend fun rule(`value`: Output<BucketServerSideEncryptionConfigurationRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value A single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("mifiyyabfuwurucr")
    public suspend fun rule(`value`: BucketServerSideEncryptionConfigurationRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument A single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("jnsnbdpjkdwovbfm")
    public suspend
    fun rule(argument: suspend BucketServerSideEncryptionConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketServerSideEncryptionConfigurationRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    internal fun build(): BucketServerSideEncryptionConfigurationArgs =
        BucketServerSideEncryptionConfigurationArgs(
            rule = rule ?: throw PulumiNullFieldException("rule"),
        )
}
